/* Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

package org.apache.myfaces.portlet.faces.testsuite.tests.chapter_5.section_5_2;

import java.io.IOException;

import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

import java.util.Set;

import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.FacesMessage;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;

import javax.faces.lifecycle.LifecycleFactory;

import javax.faces.render.ResponseStateManager;

import javax.portlet.ActionResponse;
import javax.portlet.PortalContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;

import javax.portlet.RenderRequest;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeUtil;

import org.apache.myfaces.portlet.faces.testsuite.annotation.BridgeTest;
import org.apache.myfaces.portlet.faces.testsuite.beans.TestRunnerBean;
import org.apache.myfaces.portlet.faces.testsuite.beans.AnnotatedExcludedBean;
import org.apache.myfaces.portlet.faces.testsuite.common.Constants;

public class Tests
  extends Object implements PhaseListener
{
  
  // Test #5.13 (also by proxy verifies #5.12
  @BridgeTest(test = "verifyPortletObjectsTest")
  public String verifyPortletObjectsTest(TestRunnerBean testRunner)
  {
    FacesContext ctx = FacesContext.getCurrentInstance();
    ExternalContext extCtx = ctx.getExternalContext();
    Map m = extCtx.getRequestMap();
    
    testRunner.setTestComplete(true);
    
    // Are we in the rightview???
    String s = (String) m.get("javax.portlet.faces.tck.verifyPortletObjectsPass");
    if (s != null)
    {
      testRunner.setTestResult(true, s);
      return Constants.TEST_SUCCESS;
    }
    else
    {
      testRunner.setTestResult(false,
                               (String) m.get("javax.portlet.faces.tck.verifyPortletObjectsFail"));
      return Constants.TEST_FAILED;
    }
  }
  
  // Test is MultiRequest -- Render/Action
  // Test #5.14
  @BridgeTest(test = "verifyPortletPhaseTest")
  public String verifyPortletPhaseTest(TestRunnerBean testRunner)
  { 
    FacesContext ctx = FacesContext.getCurrentInstance();
    ExternalContext extCtx = ctx.getExternalContext();
    Map m = extCtx.getRequestMap();
    
    // In the action portion create/attach things to request scope that should either be preserved or
    // are explicitly excluded -- test for presence/absence in render
    if (BridgeUtil.getPortletRequestPhase() ==
        Bridge.PortletPhase.ACTION_PHASE)
    {
          
      return "verifyPortletPhaseTest"; // action Navigation result
    }
    else
    {
      testRunner.setTestComplete(true);
     
      // Now verify that what should have been carried forward has and what shouldn't hasn't.
      
      String s = (String) m.get("javax.portlet.faces.tck.verifyPortletPhaseDuringActionPass");
      String s1 = (String) m.get("javax.portlet.faces.tck.verifyPortletPhaseDuringRenderPass");
      
      if (s != null && s1 != null)
      {
        testRunner.setTestResult(true, s + s1);
        return Constants.TEST_SUCCESS;
      }
      
      if (s == null)
      {
        s = (String) m.get("javax.portlet.faces.tck.verifyPortletPhaseDuringActionFail");
      }
      
      if (s1 == null)
      {
        s1 = (String) m.get("javax.portlet.faces.tck.verifyPortletPhaseDuringRenderFail");
      }
      
      testRunner.setTestResult(false,s + s1);
      return Constants.TEST_FAILED;    

    }
  }
  
  // Test is MultiRequest -- Render/Action
  // Test #5.18
  @BridgeTest(test = "renderRedirectTest")
  public String renderRedirectTest(TestRunnerBean testRunner)
  { 
    FacesContext ctx = FacesContext.getCurrentInstance();
    ExternalContext extCtx = ctx.getExternalContext();
    Map m = extCtx.getRequestMap();
    
    // In the action portion create/attach things to request scope that should either be preserved or
    // are explicitly excluded -- test for presence/absence in render
    if (BridgeUtil.getPortletRequestPhase() ==
        Bridge.PortletPhase.ACTION_PHASE)
    {
          
      return "renderRedirectTest"; // action Navigation result
    }
    else
    {
      String viewId = ctx.getViewRoot().getViewId();
      if (viewId.equals("/tests/MultiRequestTestResultRenderCheck.jsp"))
      {
        // issue the redirect
        ViewHandler viewHandler = ctx.getApplication().getViewHandler();
        try
        {
          extCtx.redirect(viewHandler.getActionURL(ctx, "/tests/RedisplayRenderRequestTest.jsp"));
        }
        catch (IOException e)
        {
          testRunner.setTestComplete(true);
          testRunner.setTestResult(false,
                                   "Call to render redirect threw an IOException: " + e.getMessage());
          return Constants.TEST_FAILED;
        }
        return "renderRedirectTest";
      }
      else if (viewId.equals("/tests/RedisplayRenderRequestTest.jsp"))
      {
        // If redisplay hasn't been invoked yet -- merely return
        if (extCtx.getSessionMap().get("org.apache.portlet.faces.tck.redisplay") == null)
        {
          // because this is a redirect during render -- we can't pass new/additional parameters on
          // the redisplay -- since the bridge ignores them (it uses the ones from the original redirect
          // so instead mark that we have done the redisplay in the session
          extCtx.getSessionMap().put("org.apache.portlet.faces.tck.redisplay", Boolean.TRUE);
          return "renderRedirectTest";
        }
      
        testRunner.setTestComplete(true);
        extCtx.getSessionMap().remove("org.apache.portlet.faces.tck.redisplay");
         
        testRunner.setTestResult(true, 
                                 "Redisplay after redirect correctly rendered the redirected view.");
        return Constants.TEST_SUCCESS;
      }
      else
      {
        testRunner.setTestComplete(true);
        extCtx.getSessionMap().remove("org.apache.portlet.faces.tck.redisplay");
        testRunner.setTestResult(false, 
                                 "Ended up in an unexpected view during renderRedirect test:");
        return Constants.TEST_FAILED;    
      }
    }
  }
  
  // Test is MultiRequest -- Render/Action
  // Test #5.19
  @BridgeTest(test = "ignoreCurrentViewIdModeChangeTest")
  public String ignoreCurrentViewIdModeChangeTest(TestRunnerBean testRunner)
  { 
    FacesContext ctx = FacesContext.getCurrentInstance();
    ExternalContext extCtx = ctx.getExternalContext();
    
    // In the action portion create/attach things to request scope that should either be preserved or
    // are explicitly excluded -- test for presence/absence in render
    if (BridgeUtil.getPortletRequestPhase() ==
        Bridge.PortletPhase.ACTION_PHASE)
    {
      return "ignoreCurrentViewIdModeChangeTest"; // action Navigation result
    }
    else
    {
      // If redisplay hasn't been invoked yet -- merely return
      if (extCtx.getRequestParameterMap().get("org.apache.portlet.faces.tck.redisplay") == null)
      {
        return "ignoreCurrentViewIdModeChangeTest";
      }
      // We should now be in the default view for edit Mode
      String viewId = ctx.getViewRoot().getViewId();
      
      testRunner.setTestComplete(true);
      if (viewId.equals("/tests/MultiRequestTestResultRenderCheck.jsp"))
      {
        testRunner.setTestResult(true,
                                 "Second render correctly used the default view because there was a mode change.");
        return Constants.TEST_SUCCESS;
      }
      else 
      {
        testRunner.setTestResult(false,
                                 "Second render incorrectly rerendered existing view though there was a view change.");
        return Constants.TEST_FAILED;
      }
    }
  }
  
  // Test is MultiRequest -- Render/Action
  // Test #5.20
  @BridgeTest(test = "exceptionThrownWhenNoDefaultViewIdTest")
  public String exceptionThrownWhenNoDefaultViewIdTest(TestRunnerBean testRunner)
  { 
    FacesContext ctx = FacesContext.getCurrentInstance();
    ExternalContext extCtx = ctx.getExternalContext();
    
    // In the action portion create/attach things to request scope that should either be preserved or
    // are explicitly excluded -- test for presence/absence in render
    if (BridgeUtil.getPortletRequestPhase() ==
        Bridge.PortletPhase.ACTION_PHASE)
    {
      return "exceptionThrownWhenNoDefaultViewIdTest"; // action Navigation result
    }
    else
    {
      // If redisplay hasn't been invoked yet -- merely return
      if (extCtx.getRequestParameterMap().get("org.apache.portlet.faces.tck.redisplay") == null)
      {
        return "exceptionThrownWhenNoDefaultViewIdTest";
      }
      
      // Note we should never get here because the default viewId isn't defined.
      // We should now be in the default view for edit Mode
      testRunner.setTestComplete(true);
      
      testRunner.setTestResult(false,
                                "Unexpectedly ended up in render -- should of had a BridgeDefaultViewNotSpecifiedException thrown.");
      return Constants.TEST_FAILED;
    }
  }
  
  // Test is MultiRequest -- Render/Action
  // Test #5.20 (first test of 2) -- viewId set directly by portlet using request attribute 
  @BridgeTest(test = "viewIdWithParam_1_Test")
  public String viewIdWithParam_1_Test(TestRunnerBean testRunner)
  { 
    FacesContext ctx = FacesContext.getCurrentInstance();
    
    testRunner.setTestComplete(true);
    
    // Parameter encoded in the faces-config.xml target
    String pVal =
      ctx.getExternalContext().getRequestParameterMap().get("param1");
    if (pVal != null && pVal.equals("testValue"))
    {
      testRunner.setTestResult(true,
                               "Bridge correctly included parameter from viewId querystring when viewId set explicitly.");
      return Constants.TEST_SUCCESS;
    }
    else
    {
      if (pVal == null)
        testRunner.setTestResult(false,
                                 "Bridge didn't included parameter from viewId querystring when viewId set explicitly.");
      else
        testRunner.setTestResult(false,
                                 "Bridge didn't properly include parameter from viewId querystring when viewId set explicitly.  The resulting request contained the wrong parameter value. Expected: testValue  Received: " +
                                 pVal);
    }
    return Constants.TEST_FAILED;
  }
  
  // Test is MultiRequest -- Render/Action
  // Test #5.20 (second test of 2) -- viewId set in the default viewId (initparam) 
  @BridgeTest(test = "viewIdWithParam_2_Test")
  public String viewIdWithParam_2_Test(TestRunnerBean testRunner)
  { 
    FacesContext ctx = FacesContext.getCurrentInstance();
    
    testRunner.setTestComplete(true);
    
    // Parameter encoded in the faces-config.xml target
    String pVal =
      ctx.getExternalContext().getRequestParameterMap().get("param1");
    if (pVal != null && pVal.equals("testValue"))
    {
      testRunner.setTestResult(true,
                               "Bridge correctly included parameter from viewId querystring when using default viewId.");
      return Constants.TEST_SUCCESS;
    }
    else
    {
      if (pVal == null)
        testRunner.setTestResult(false,
                                 "Bridge didn't included parameter from viewId querystring when using default viewId.");
      else
        testRunner.setTestResult(false,
                                 "Bridge didn't properly include parameter from viewId querystring when using default viewId.  The resulting request contained the wrong parameter value. Expected: testValue  Received: " +
                                 pVal);
    }
    return Constants.TEST_FAILED;
  }
  
  // Test is MultiRequest -- Render/Action
  // Test #5.25
  @BridgeTest(test = "facesContextReleasedActionTest")
  public String facesContextReleasedActionTest(TestRunnerBean testRunner)
  { 
    FacesContext ctx = FacesContext.getCurrentInstance();
    ExternalContext extCtx = ctx.getExternalContext();
    
    // In the action portion create/attach things to request scope that should either be preserved or
    // are explicitly excluded -- test for presence/absence in render
    if (BridgeUtil.getPortletRequestPhase() ==
        Bridge.PortletPhase.ACTION_PHASE)
    {
      return "facesContextReleasedActionTest"; // action Navigation result
    }
    else
    {
      testRunner.setTestComplete(true);
      // Values set by portlet at end of action
      boolean result = ((Boolean)extCtx.getSessionMap().get("org.apache.portlet.faces.tck.testResult")).booleanValue();
      testRunner.setTestResult(result,
                                (String)extCtx.getSessionMap().get("org.apache.portlet.faces.tck.testDetail"));
      
      if (result)
        return Constants.TEST_SUCCESS;
      else
      return Constants.TEST_FAILED;
    }
  }  
  
  // Test is MultiRequest -- Render/Action
  // Test #5.26
  @BridgeTest(test = "portletPhaseRemovedActionTest")
  public String portletPhaseRemovedActionTest(TestRunnerBean testRunner)
  { 
    FacesContext ctx = FacesContext.getCurrentInstance();
    ExternalContext extCtx = ctx.getExternalContext();
    
    // In the action portion create/attach things to request scope that should either be preserved or
    // are explicitly excluded -- test for presence/absence in render
    if (BridgeUtil.getPortletRequestPhase() ==
        Bridge.PortletPhase.ACTION_PHASE)
    {
      return "portletPhaseRemovedActionTest"; // action Navigation result
    }
    else
    {
      testRunner.setTestComplete(true);
      
      // Values set by portlet at end of action
      boolean result = ((Boolean)extCtx.getSessionMap().get("org.apache.portlet.faces.tck.testResult")).booleanValue();
      testRunner.setTestResult(result,
                                (String)extCtx.getSessionMap().get("org.apache.portlet.faces.tck.testDetail"));
      
      if (result)
        return Constants.TEST_SUCCESS;
      else
      return Constants.TEST_FAILED;
    }
  }  
  
  // Test is Render test
  // Test #5.29  
  @BridgeTest(test = "bridgeSetsContentTypeTest")
  public String bridgeSetsContentTypeTest(TestRunnerBean testRunner)
  { 
    FacesContext ctx = FacesContext.getCurrentInstance();
    ExternalContext extCtx = ctx.getExternalContext();
    
    testRunner.setTestComplete(true);
    
    // Parameter encoded in the faces-config.xml target
    String responseCT = extCtx.getResponseContentType();
    String requestedCT = ((RenderRequest)extCtx.getRequest()).getResponseContentType();
    
    if (responseCT != null && requestedCT != null && responseCT.equals(requestedCT))
    {
      testRunner.setTestResult(true,
                               "Bridge correctly set the proper (default) content type when not set by portlet.");
      return Constants.TEST_SUCCESS;
    }
    else
    {
      testRunner.setTestResult(false,
                               "Bridge didn't set the proper (default) content type when not set by portlet.  Current: " + responseCT + " expected: " + requestedCT);
      return Constants.TEST_FAILED;
    }
  }
  
  // Test is MultiRequest -- Render/Action
  // Test #5.31
  @BridgeTest(test = "isPostbackTest")
  public String isPostbackTest(TestRunnerBean testRunner)
  {    
    // In the action portion create/attach things to request scope that should either be preserved or
    // are explicitly excluded -- test for presence/absence in render
    if (BridgeUtil.getPortletRequestPhase() ==
        Bridge.PortletPhase.ACTION_PHASE)
    {
      return "isPostbackTest"; // action Navigation result
    }
    else
    {
      FacesContext ctx = FacesContext.getCurrentInstance();
      ExternalContext extCtx = ctx.getExternalContext();
      
      testRunner.setTestComplete(true);
      if (ctx.getRenderKit().getResponseStateManager().isPostback(ctx))
      {
        testRunner.setTestResult(true,
                                "Render after action properly encoded so ResponseStateManager.isPostback is true.");
        return Constants.TEST_SUCCESS;  
      }
      else
      {
        testRunner.setTestResult(false,
                                "Render after action isn't properly encoded in that ResponseStateManager.isPostback is false.");
        return Constants.TEST_FAILED;
      }
    }
  } 

  // Test is SingleRequest -- Render/Action
  // Test #5.33 -- 
  @BridgeTest(test = "renderPhaseListenerTest")
  public String renderPhaseListenerTest(TestRunnerBean testRunner)
  { 
    FacesContext ctx = FacesContext.getCurrentInstance();
    ExternalContext extCtx = ctx.getExternalContext();
    Map<String, Object> m = extCtx.getRequestMap();
    
    testRunner.setTestComplete(true);
      
    //Phase Listener (below) has set these attributes
    PhaseId lastBeforePhaseId = (PhaseId) m.get("org.apache.portlet.faces.tck.lastBeforePhase");
    PhaseId lastAfterPhaseId = (PhaseId) m.get("org.apache.portlet.faces.tck.lastAfterPhase");
    
    if (lastBeforePhaseId == null || lastAfterPhaseId == null)
    {
      testRunner.setTestResult(false,
                               "Render incorrectly didn't invoke either or both the RESTORE_VIEW before/after listener.");
      return Constants.TEST_FAILED;
    }
    else if (lastBeforePhaseId == PhaseId.RESTORE_VIEW && lastAfterPhaseId == PhaseId.RESTORE_VIEW)
    {
      testRunner.setTestResult(true,
                                "Render properly invoked the RESTORE_VIEW phase including calling its before/after listeners and didnt' execute any other action phases.");
      return Constants.TEST_SUCCESS;  
    }
    else
    {
      testRunner.setTestResult(false,
                               "Render incorrectly executed an action phase/listener post RESTORE_VIEW: lastBeforePhase: " +
                               lastBeforePhaseId.toString() + " lastAfterPhase: " + lastAfterPhaseId.toString());
      return Constants.TEST_FAILED;
    }
  }   
  
  public PhaseId getPhaseId()
  {
    return PhaseId.ANY_PHASE;
  }
  
  public void beforePhase(PhaseEvent event)
  {
    PhaseId phase = event.getPhaseId();
    
    // Do nothing if in render phase
    if (phase == PhaseId.RENDER_RESPONSE)
    {
      return;
    }
    
    
    FacesContext ctx = event.getFacesContext();
    Map<String, Object> m = ctx.getExternalContext().getRequestMap();
    String testname = (String) m.get(Constants.TEST_NAME);
    Bridge.PortletPhase portletPhase = (Bridge.PortletPhase) m.get(Bridge.PORTLET_LIFECYCLE_PHASE);
    if (testname.equals("renderPhaseListenerTest") && portletPhase.equals(Bridge.PortletPhase.RENDER_PHASE))
    {
      m.put("org.apache.portlet.faces.tck.lastBeforePhase", phase);
    }
  }
  
  public void afterPhase(PhaseEvent event)
  {
    PhaseId phase = event.getPhaseId();
    
    // Do nothing if in render phase
    if (phase == PhaseId.RENDER_RESPONSE)
    {
      return;
    }
    
    
    FacesContext ctx = event.getFacesContext();
    Map<String, Object> m = ctx.getExternalContext().getRequestMap();
    String testname = (String) m.get(Constants.TEST_NAME);
    Bridge.PortletPhase portletPhase = (Bridge.PortletPhase) m.get(Bridge.PORTLET_LIFECYCLE_PHASE);
    if (testname.equals("renderPhaseListenerTest") && portletPhase.equals(Bridge.PortletPhase.RENDER_PHASE))
    {
      m.put("org.apache.portlet.faces.tck.lastAfterPhase", phase);
    }
    
    if (testname.equals("facesContextReleasedRenderTest") || testname.equals("portletPhaseRemovedRenderTest"))
    {
      // prematurely prevent render from happening as the Portlet needs to write to the response once it verifys that the 
      // corresponding elements were cleaned up
      ctx.responseComplete();
    }
  }
     
}
