/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.component.core.layout.CorePanelButtonBar;
import org.apache.myfaces.trinidad.context.PartialPageContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.share.url.FormEncoder;
import org.apache.myfaces.trinidadinternal.share.url.URLEncoder;
import org.apache.myfaces.trinidadinternal.ui.AttributeKey;
import org.apache.myfaces.trinidadinternal.ui.MutableUINode;
import org.apache.myfaces.trinidadinternal.ui.NodeUtils;
import org.apache.myfaces.trinidadinternal.ui.TextNode;
import org.apache.myfaces.trinidadinternal.ui.UINode;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.beans.MarlinBean;
import org.apache.myfaces.trinidadinternal.ui.data.DataObject;
import org.apache.myfaces.trinidadinternal.ui.data.DataObjectList;
import org.apache.myfaces.trinidadinternal.ui.data.bind.AccessKeyBoundValue;
import org.apache.myfaces.trinidadinternal.ui.laf.base.SkinTranslatedBoundValue;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.FormValueRenderer;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.LinkDataObject;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.XhtmlLafRenderer;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.XhtmlLafUtils;
import org.apache.myfaces.trinidadinternal.ui.partial.PartialPageRendererUtils;

@Deprecated
public abstract class NavigationBarRenderer
extends XhtmlLafRenderer {
    private static UINode _sEmptyRangeNode;
    private static final String _SINGLE_BACK_TEXT_KEY = "af_singleStepButtonBar.BACK";
    private static final String _SINGLE_NEXT_TEXT_KEY = "af_singleStepButtonBar.NEXT";
    private static final String _SINGLE_CONTINUE_TEXT_KEY = "af_singleStepButtonBar.CONTINUE";
    private static final String _SINGLE_RANGE_FORMAT_TOTAL_STRING = "af_singleStepButtonBar.FORMAT_TOTAL";
    private static final String _SINGLE_RANGE_FORMAT_NO_TOTAL_STRING = "af_singleStepButtonBar.FORMAT_NO_TOTAL";
    private static final String _STEP_TEXT_KEY = "af_singleStepButtonBar.STEP";
    private static final String _PREVIOUS_DESC_KEY = "af_table.SELECT_RANGE_PREVIOUS_TIP";
    private static final String _NEXT_DESC_KEY = "af_table.SELECT_RANGE_NEXT_TIP";
    private static final String _DISABLED_PREVIOUS_DESC_KEY = "af_table.SELECT_RANGE_PREV_DISABLED_TIP";
    private static final String _DISABLED_NEXT_DESC_KEY = "af_table.SELECT_RANGE_NEXT_DISABLED_TIP";
    private static final String _MULTI_RANGE_FORMAT_TOTAL_STRING = "af_table.SELECT_RANGE_CHOICE_FORMAT_TOTAL";
    private static final String _MULTI_RANGE_FORMAT_NO_TOTAL_STRING = "af_table.SELECT_RANGE_CHOICE_FORMAT_NO_TOTAL";
    private static final String _CHOICE_TIP_KEY = "af_table.SELECT_RANGE_CHOICE_TIP";
    private static final String _SELECT_RANGE_PREVIOUS_KEY = "af_table.SELECT_RANGE_PREVIOUS";
    private static final String _SELECT_RANGE_NEXT_KEY = "af_table.SELECT_RANGE_NEXT";
    private static final String _SELECT_RANGE_DISABLED_PREVIOUS_KEY = "af_table.SELECT_RANGE_DISABLED_PREVIOUS";
    private static final String _SELECT_RANGE_DISABLED_NEXT_KEY = "af_table.SELECT_RANGE_DISABLED_NEXT";
    private static final String _SHOW_ALL_KEY = "af_table.SELECT_RANGE_SHOW_ALL";
    private static final String _PREVIOUS_TEXT_KEY = "af_table.SELECT_RANGE_PREVIOUS_OPTION";
    private static final String _MORE_TEXT_KEY = "af_table.SELECT_RANGE_MORE_OPTION";
    private static final String _STRING_RANGE_FORMAT_STRING = "NAVBAR_STRING_RANGE_FORMAT";
    private static final long _MAX_VISIBLE_OPTIONS = 30L;
    private static final String _CHOICE_ON_CHANGE_START = "window.self.location.href = '";
    private static final String _CHOICE_ON_CHANGE_END = "&value=' + this.options[this.selectedIndex].value";
    private static final String _LINK_ON_CHANGE_FORM_START = "_navBarSubmit('";
    private static final String _CHOICE_ON_CHANGE_FORM_START = "_navChoiceSubmit(this, '";
    private static final String _CHOICE_ON_CHANGE_FORM_END = ")";
    private static final String[] _NAVBAR_SUBMIT_SCRIPT;
    private static final int _NAVBAR_SUBMIT_SCRIPT_LENGTH;
    private static final String _CHOICE_SUBMIT_SCRIPT = "function _navChoiceSubmit(choice, formName, event, navBar, vld, size, partialTargets){if (!_navBarSubmit(formName, event, navBar, vld, choice.options[choice.selectedIndex].value, size, partialTargets)){choice.selectedIndex = choice._lastValue;}}";
    private static final String _CHOICE_FORM_ON_FOCUS = "this._lastValue = this.selectedIndex";
    private static final String _NAVBAR_SUBMIT_JAVASCRIPT_RENDERED = "_NAVBAR_SUBMIT_JAVASCRIPT_RENDERED";
    private static final String _FIRE_PARTIAL_CHANGE_START = "_firePartialChange('";
    private static final String _FIRE_PARTIAL_CHANGE_END = "&value=' + this.options[this.selectedIndex].value);return false;";
    private static final AttributeKey _INDEX_NAMES_ATTR;

    protected MutableUINode createSingleItemURLButton(UIXRenderingContext context, boolean isBack, Object buttonText, Object buttonAccessKey, String destinationURL) {
        MarlinBean urlButton = new MarlinBean("button");
        urlButton.setAttributeValue(TEXT_ATTR, buttonText);
        urlButton.setAttributeValue(ACCESS_KEY_ATTR, buttonAccessKey);
        urlButton.setAttributeValue(DESTINATION_ATTR, destinationURL);
        return urlButton;
    }

    protected MutableUINode createSingleItemSubmitButton(UIXRenderingContext context, boolean isBack, Object buttonText, Object buttonAccessKey, String onClickJS) {
        MarlinBean submitButton = new MarlinBean("button");
        submitButton.setAttributeValue(TEXT_ATTR, buttonText);
        submitButton.setAttributeValue(ACCESS_KEY_ATTR, buttonAccessKey);
        submitButton.setOnClick(onClickJS);
        return submitButton;
    }

    protected void prerender(UIXRenderingContext context, UINode node) throws IOException {
        int visibleItemCount;
        URLEncoder encoder = context.getURLEncoder();
        String eventKey = encoder.encodeParameter("event");
        String sourceKey = encoder.encodeParameter("source");
        String valueKey = encoder.encodeParameter("value");
        String sizeKey = encoder.encodeParameter("size");
        String partialTargetsKey = encoder.encodeParameter("partialTargets");
        String partialTargets = NavigationBarRenderer._getPartialTargets(context, node);
        Number result = (Number)node.getAttributeValue(context, BLOCK_SIZE_ATTR);
        int n = visibleItemCount = result != null ? result.intValue() : -1;
        if (visibleItemCount == -1) {
            this._renderSingleItemNavigator(context, node, eventKey, sourceKey, valueKey, sizeKey, partialTargetsKey, partialTargets);
        } else {
            this._renderMultiItemNavigator(context, node, visibleItemCount, eventKey, sourceKey, valueKey, sizeKey, partialTargetsKey, partialTargets);
        }
    }

    protected void postrender(UIXRenderingContext context, UINode node) throws IOException {
    }

    protected void renderContent(UIXRenderingContext context, UINode node) {
    }

    private void _renderSingleItemNavigator(UIXRenderingContext context, UINode navBar, String eventKey, String sourceKey, String valueKey, String sizeKey, String partialTargetsKey, String partialTargets) throws IOException {
        boolean supportsScripting;
        boolean showNextButton;
        Number result = (Number)navBar.getAttributeValue(context, VALUE_ATTR);
        long currentValue = result != null ? result.longValue() : 1L;
        int childCount = navBar.getIndexedChildCount(context);
        long totalItems = childCount > 0 ? (long)childCount : ((result = (Number)navBar.getAttributeValue(context, MAX_VALUE_ATTR)) != null ? result.longValue() : -1L);
        boolean showBackButton = currentValue > 1L;
        boolean bl = showNextButton = totalItems == -1L || currentValue < totalItems;
        if (!showBackButton && !showNextButton || currentValue > totalItems && totalItems != -1L || currentValue < -1L) {
            return;
        }
        String formName = XhtmlLafUtils.getParentFormName(context);
        boolean bl2 = supportsScripting = NavigationBarRenderer.supportsScripting(context) || !NavigationBarRenderer.supportsNavigation(context);
        if (formName != null && supportsScripting) {
            NavigationBarRenderer.renderHiddenFields(context, formName, false, eventKey, sourceKey, valueKey, sizeKey, partialTargetsKey, partialTargets);
        }
        String nameString = this._getNameString(context, navBar);
        UINode backButton = null;
        UINode nextButton = null;
        if (showBackButton) {
            SkinTranslatedBoundValue buttonTextandAccessKeyBV = new SkinTranslatedBoundValue(_SINGLE_BACK_TEXT_KEY);
            AccessKeyBoundValue buttonTextBV = new AccessKeyBoundValue(buttonTextandAccessKeyBV, false);
            AccessKeyBoundValue buttonAccessKeyBV = new AccessKeyBoundValue(buttonTextandAccessKeyBV, true);
            backButton = formName == null ? this.createSingleItemURLButton(context, true, buttonTextBV, buttonAccessKeyBV, NavigationBarRenderer.getSingleDestinationURL(context, navBar, eventKey, sourceKey, nameString, valueKey, currentValue - 1L)) : (supportsScripting ? this.createSingleItemSubmitButton(context, true, buttonTextBV, buttonAccessKeyBV, NavigationBarRenderer.getSingleDestinationSubmit(context, navBar, formName, eventKey, sourceKey, nameString, valueKey, currentValue - 1L, false)) : NavigationBarRenderer.createSubmitButton(context, buttonTextBV, buttonAccessKeyBV, null, formName, false, eventKey, sourceKey, nameString, valueKey, currentValue - 1L, null, -1));
        }
        if (showNextButton) {
            MutableUINode mutableNextButton;
            String buttonTextKey = totalItems == 2L ? _SINGLE_CONTINUE_TEXT_KEY : _SINGLE_NEXT_TEXT_KEY;
            SkinTranslatedBoundValue buttonTextandAccessKeyBV = new SkinTranslatedBoundValue(buttonTextKey);
            AccessKeyBoundValue buttonTextBV = new AccessKeyBoundValue(buttonTextandAccessKeyBV, false);
            AccessKeyBoundValue buttonAccessKeyBV = new AccessKeyBoundValue(buttonTextandAccessKeyBV, true);
            String buttonID = this._getIDForFocus(context, navBar);
            if (formName == null) {
                mutableNextButton = this.createSingleItemURLButton(context, false, buttonTextBV, buttonAccessKeyBV, NavigationBarRenderer.getSingleDestinationURL(context, navBar, eventKey, sourceKey, nameString, valueKey, currentValue + 1L));
                if (buttonID != null) {
                    mutableNextButton.setID(buttonID);
                }
                nextButton = mutableNextButton;
            } else if (supportsScripting) {
                mutableNextButton = this.createSingleItemSubmitButton(context, false, buttonTextBV, buttonAccessKeyBV, NavigationBarRenderer.getSingleDestinationSubmit(context, navBar, formName, nameString, currentValue + 1L, true));
                if (buttonID != null) {
                    mutableNextButton.setID(buttonID);
                }
                nextButton = mutableNextButton;
            } else {
                nextButton = NavigationBarRenderer.createSubmitButton(context, buttonTextBV, buttonAccessKeyBV, buttonID, formName, false, eventKey, sourceKey, nameString, valueKey, currentValue + 1L, null, -1);
            }
        }
        ResponseWriter writer = context.getResponseWriter();
        boolean renderAsTable = this._renderAsTable(context, navBar);
        if (renderAsTable) {
            writer.startElement("table", navBar.getUIComponent());
            NavigationBarRenderer.renderLayoutTableAttributes(context, "0", null);
            this.renderID(context, navBar);
            writer.startElement("tr", null);
        }
        this._renderStartTableCell(context, navBar, writer, renderAsTable, true);
        if (showBackButton) {
            backButton.render(context);
            writer.endElement("td");
            this._renderSpacerCell(context);
            this._renderStartTableCell(context, navBar, writer, renderAsTable, false);
        }
        writer.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
        if (childCount == 0 || formName == null && this.requiresForm(context) || !NavigationBarRenderer.supportsScripting(context)) {
            if (totalItems > 2L) {
                String rangeString = this._getRangeString(context, navBar, currentValue, -1, totalItems, null);
                MarlinBean stepLabel = new MarlinBean("styledText");
                stepLabel.setAttributeValue(TEXT_ATTR, rangeString);
                stepLabel.setStyleClass("OraNavBarViewOnly");
                stepLabel.render(context);
            }
        } else {
            DataObjectList links = LinkDataObject.getLinkDataList(context, navBar);
            MarlinBean choice = new MarlinBean("choice");
            int maxVisited = (int)currentValue;
            Object maxVisitedObj = navBar.getAttributeValue(context, MAX_VISITED_ATTR);
            if (maxVisitedObj instanceof Number) {
                maxVisited = ((Number)maxVisitedObj).intValue();
            }
            maxVisited = Math.min(maxVisited, links == null ? 0 : links.getLength());
            for (int i = 0; i < maxVisited; ++i) {
                DataObject link = links.getItem(i);
                MarlinBean option = new MarlinBean("option");
                option.setAttributeValue(TEXT_ATTR, link.selectValue(context, TEXT_ATTR));
                option.setAttributeValue(VALUE_ATTR, IntegerUtils.getString((int)(i + 1)));
                if (currentValue == (long)(i + 1)) {
                    option.setAttributeValue(SELECTED_ATTR, Boolean.TRUE);
                }
                choice.addIndexedChild(option);
            }
            if (choice.getIndexedChildCount(context) > 0) {
                String name = this._getNameString(context, navBar);
                String onChange = formName == null ? this._getChoiceOnChange(context, NavigationBarRenderer._getDestinationString(context, navBar), sourceKey, eventKey, name, null, null) : this._getChoiceOnChangeFormSubmitted(context, navBar, formName, eventKey, sourceKey, name, partialTargetsKey, null);
                choice.setAttributeValue(ON_CHANGE_ATTR, onChange);
            } else {
                choice.setAttributeValue(READ_ONLY_ATTR, Boolean.TRUE);
            }
            choice.render(context);
        }
        if (showNextButton) {
            writer.endElement("td");
            this._renderSpacerCell(context);
            this._renderStartTableCell(context, navBar, writer, renderAsTable, false);
            nextButton.render(context);
        }
        writer.endElement("td");
        if (renderAsTable) {
            writer.endElement("tr");
            writer.endElement("table");
        }
    }

    private String _getChoiceOnChange(UIXRenderingContext context, String destination, String sourceKey, String eventKey, String name, String partialTargets, String partialTargetsKey) {
        String endScript;
        String startScript;
        String[] keysAndValues;
        int initialSize = destination.length() + sourceKey.length() + eventKey.length() + name.length() + 8;
        if (partialTargets != null) {
            keysAndValues = new String[]{sourceKey, name, eventKey, "goto", partialTargetsKey, partialTargets};
            startScript = _FIRE_PARTIAL_CHANGE_START;
            endScript = _FIRE_PARTIAL_CHANGE_END;
            initialSize += partialTargetsKey.length() + partialTargets.length() + 2;
        } else {
            keysAndValues = new String[]{sourceKey, name, eventKey, "goto"};
            startScript = _CHOICE_ON_CHANGE_START;
            endScript = _CHOICE_ON_CHANGE_END;
        }
        int bufferlength = initialSize + startScript.length() + endScript.length();
        StringBuffer buffer = new StringBuffer(bufferlength);
        StringBuffer urlBuffer = new StringBuffer(initialSize);
        buffer.append(startScript);
        NavigationBarRenderer.appendURLArguments(urlBuffer, destination, keysAndValues);
        String url = urlBuffer.toString();
        FacesContext facesContext = context.getFacesContext();
        if (facesContext != null) {
            url = facesContext.getExternalContext().encodeActionURL(url);
        }
        buffer.append(url);
        buffer.append(endScript);
        return buffer.toString();
    }

    private String _getChoiceOnChangeFormSubmitted(UIXRenderingContext context, UINode node, String form, String eventKey, String sourceKey, String name, String partialTargetsKey, String partialTargets) {
        FormEncoder formEncoder = context.getFormEncoder();
        String encodedGotoEvent = XhtmlLafUtils.getFormEncodedParameter(formEncoder, form, eventKey, "goto");
        String encodedSource = XhtmlLafUtils.getFormEncodedParameter(formEncoder, form, sourceKey, name);
        String encodedPartialTargets = XhtmlLafUtils.getFormEncodedParameter(formEncoder, form, partialTargetsKey, partialTargets);
        int initialSize = _CHOICE_ON_CHANGE_FORM_START.length() + form.length() + 13 + encodedSource.length() + _CHOICE_ON_CHANGE_FORM_END.length();
        if (encodedPartialTargets != null) {
            initialSize += encodedPartialTargets.length() + 2;
        }
        StringBuffer buffer = new StringBuffer(initialSize);
        buffer.append(_CHOICE_ON_CHANGE_FORM_START);
        buffer.append(form);
        buffer.append("','");
        buffer.append(encodedGotoEvent);
        buffer.append("','");
        buffer.append(encodedSource);
        if (NavigationBarRenderer._doValidate(context, node)) {
            buffer.append("',1");
        } else {
            buffer.append("',0");
        }
        if (encodedPartialTargets != null) {
            buffer.append(",null,");
            buffer.append("'");
            buffer.append(encodedPartialTargets);
            buffer.append("'");
        }
        buffer.append(_CHOICE_ON_CHANGE_FORM_END);
        return buffer.toString();
    }

    private void _renderMultiItemNavigator(UIXRenderingContext context, UINode navBar, int blockSize, String eventKey, String sourceKey, String valueKey, String sizeKey, String partialTargetsKey, String partialTargets) throws IOException {
        Object showAll;
        boolean atShowAll;
        boolean showNextButton;
        Number result = (Number)navBar.getAttributeValue(context, VALUE_ATTR);
        long currentValue = result != null ? result.longValue() : 1L;
        result = (Number)navBar.getAttributeValue(context, MIN_VALUE_ATTR);
        long minValue = result != null ? result.longValue() : 1L;
        result = (Number)navBar.getAttributeValue(context, MAX_VALUE_ATTR);
        long maxValue = result != null ? result.longValue() : -1L;
        String destinationString = NavigationBarRenderer._getDestinationString(context, navBar);
        String nameString = this._getNameString(context, navBar);
        String formName = XhtmlLafUtils.getParentFormName(context);
        int nextRecords = 0;
        int backRecords = 0;
        long backValue = 0L;
        long nextValue = 0L;
        if (blockSize > 0) {
            long lNextRecords = blockSize;
            if (maxValue != -1L) {
                lNextRecords = maxValue - (currentValue + (long)blockSize - 1L);
            }
            long lBackRecords = currentValue - minValue;
            nextRecords = lNextRecords > (long)blockSize ? blockSize : (int)lNextRecords;
            backRecords = lBackRecords > (long)blockSize ? blockSize : (int)lBackRecords;
            backValue = currentValue - (long)backRecords;
            nextValue = currentValue + (long)blockSize;
        }
        String prevDestination = null;
        String nextDestination = null;
        String prevOnClick = null;
        String nextOnClick = null;
        UINode leftArrow = null;
        UINode rightArrow = null;
        UINode leftLink = null;
        UINode rightLink = null;
        boolean validate = false;
        boolean createSubmitButton = false;
        boolean showDisabledNavigation = this.disabledNavigationShown(context);
        boolean hasBackRecords = backRecords > 0;
        boolean hasNextRecords = nextRecords > 0;
        boolean showBackButton = hasBackRecords || showDisabledNavigation;
        boolean bl = showNextButton = hasNextRecords || showDisabledNavigation;
        if (!NavigationBarRenderer.supportsNavigation(context)) {
            showBackButton = false;
            showNextButton = false;
        }
        if (atShowAll = "active".equals(showAll = navBar.getAttributeValue(context, SHOW_ALL_ATTR))) {
            backRecords = 0;
            nextRecords = 0;
        }
        if (formName == null) {
            if (hasBackRecords && !atShowAll) {
                prevDestination = this._getMultiDestinationURL(destinationString, eventKey, sourceKey, nameString, valueKey, backValue, sizeKey, partialTargetsKey, backRecords, partialTargets);
                if (partialTargets != null) {
                    prevOnClick = XhtmlLafUtils.getFirePartialChangeHandler(prevDestination);
                    prevDestination = "#";
                }
            }
            if (hasNextRecords && !atShowAll) {
                nextDestination = this._getMultiDestinationURL(destinationString, eventKey, sourceKey, nameString, valueKey, nextValue, sizeKey, partialTargetsKey, nextRecords, partialTargets);
                if (partialTargets != null) {
                    nextOnClick = XhtmlLafUtils.getFirePartialChangeHandler(nextDestination);
                    nextDestination = "#";
                }
            }
        } else {
            validate = NavigationBarRenderer._doValidate(context, navBar);
            if (NavigationBarRenderer.supportsScripting(context)) {
                if (hasBackRecords && !atShowAll) {
                    prevDestination = "#";
                    prevOnClick = this._getMultiDestinationSubmit(context, formName, eventKey, sourceKey, nameString, valueKey, backValue, sizeKey, backRecords, validate, partialTargetsKey, partialTargets);
                }
                if (hasNextRecords && !atShowAll) {
                    nextDestination = "#";
                    nextOnClick = this._getMultiDestinationSubmit(context, formName, eventKey, sourceKey, nameString, valueKey, nextValue, sizeKey, nextRecords, validate, partialTargetsKey, partialTargets);
                }
                if (hasBackRecords || hasNextRecords) {
                    NavigationBarRenderer.renderHiddenFields(context, formName, true, eventKey, sourceKey, valueKey, sizeKey, partialTargetsKey, partialTargets);
                }
            } else {
                createSubmitButton = true;
            }
        }
        if (createSubmitButton) {
            if (showBackButton) {
                leftArrow = NavigationBarRenderer.createSubmitButton(context, this._getMultiSubmitButtonText(context, true, backRecords), null, null, formName, validate, eventKey, sourceKey, nameString, valueKey, backValue, sizeKey, backRecords);
            }
            if (showNextButton) {
                rightArrow = NavigationBarRenderer.createSubmitButton(context, this._getMultiSubmitButtonText(context, false, nextRecords), null, null, formName, validate, eventKey, sourceKey, nameString, valueKey, nextValue, sizeKey, nextRecords);
            }
        } else {
            if (showBackButton) {
                leftArrow = this._createArrowImage(context, true, prevDestination, prevOnClick);
                leftLink = this._createTextLink(context, navBar, true, prevDestination, prevOnClick, backRecords);
            }
            if (showNextButton) {
                rightArrow = this._createArrowImage(context, false, nextDestination, nextOnClick);
                rightLink = this._createTextLink(context, navBar, false, nextDestination, nextOnClick, nextRecords);
            }
        }
        UINode rangeNode = this._createRangeNode(context, navBar, destinationString, nameString, formName, minValue, currentValue, blockSize, maxValue, eventKey, sourceKey, sizeKey, partialTargetsKey, partialTargets);
        ResponseWriter writer = context.getResponseWriter();
        boolean renderAsTable = this._renderAsTable(context, navBar);
        String iconID = null;
        Object id = NavigationBarRenderer.supportsID(context) ? this.getID(context, navBar) : null;
        TrinidadAgent agent = context.getAgent();
        if (id != null && partialTargets != null && agent.getAgentApplication() == 2) {
            iconID = id.toString() + "-i";
        }
        if (renderAsTable) {
            writer.startElement("table", null);
            NavigationBarRenderer.renderLayoutTableAttributes(context, "0", null);
            this.renderID(context, navBar);
            writer.startElement("tr", null);
        }
        boolean isBaseID = true;
        if (leftArrow != null) {
            if (iconID != null) {
                writer.startElement("td", null);
                this.renderAttribute(context, "id", iconID);
                PartialPageContext pprContext = context.getPartialPageContext();
                if (pprContext != null && pprContext.isInsidePartialTarget()) {
                    pprContext.addRenderedPartialTarget(iconID);
                }
            } else {
                this._renderStartTableCell(context, navBar, writer, renderAsTable, isBaseID);
                isBaseID = false;
            }
            writer.writeAttribute("valign", (Object)"middle", null);
            leftArrow.render(context);
            writer.endElement("td");
            this._renderSpacerCell(context);
        }
        if (leftLink != null) {
            this._renderStartTableCell(context, navBar, writer, renderAsTable, isBaseID);
            isBaseID = false;
            writer.writeAttribute("valign", (Object)"middle", null);
            writer.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
            leftLink.render(context);
            writer.endElement("td");
            this._renderSpacerCell(context);
        }
        this._renderStartTableCell(context, navBar, writer, renderAsTable, isBaseID);
        isBaseID = false;
        writer.writeAttribute("valign", (Object)"middle", null);
        writer.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
        rangeNode.render(context);
        writer.endElement("td");
        if (rightLink != null) {
            this._renderSpacerCell(context);
            this._renderStartTableCell(context, navBar, writer, renderAsTable, false);
            writer.writeAttribute("valign", (Object)"middle", null);
            writer.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
            rightLink.render(context);
            writer.endElement("td");
        }
        if (rightArrow != null) {
            this._renderSpacerCell(context);
            this._renderStartTableCell(context, navBar, writer, renderAsTable, false);
            writer.writeAttribute("valign", (Object)"middle", null);
            rightArrow.render(context);
            writer.endElement("td");
        }
        if (renderAsTable) {
            writer.endElement("tr");
            writer.endElement("table");
        }
    }

    private static String _getDestinationString(UIXRenderingContext context, UINode node) {
        Object destination = node.getAttributeValue(context, DESTINATION_ATTR);
        String destinationString = null;
        if (destination == null) {
            destinationString = context.getURLEncoder().getDefaultURL();
            if (destinationString == null) {
                destinationString = "";
            }
        } else {
            destinationString = destination.toString();
        }
        return destinationString;
    }

    private String _getNameString(UIXRenderingContext context, UINode node) {
        Object name = node.getAttributeValue(context, NAME_ATTR);
        if (name != null) {
            return name.toString();
        }
        return "";
    }

    public static void renderHiddenFields(UIXRenderingContext context, String formName, boolean isMulti, String eventKey, String sourceKey, String valueKey, String sizeKey, String partialTargetsKey, String partialTargets) throws IOException {
        assert (NavigationBarRenderer.supportsScripting(context));
        if (formName != null && context.getProperty("http://myfaces.apache.org/uix/ui", _NAVBAR_SUBMIT_JAVASCRIPT_RENDERED) == null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("script", null);
            NavigationBarRenderer.renderScriptDeferAttribute(context);
            XhtmlLafRenderer.renderScriptTypeAttribute(context);
            writer.write(NavigationBarRenderer._getNavBarSubmitScript(eventKey, sourceKey, valueKey, sizeKey, partialTargetsKey));
            writer.write(_CHOICE_SUBMIT_SCRIPT);
            writer.endElement("script");
            context.setProperty("http://myfaces.apache.org/uix/ui", _NAVBAR_SUBMIT_JAVASCRIPT_RENDERED, Boolean.TRUE);
        }
        FormValueRenderer.addNeededValue(context, formName, eventKey, sourceKey, valueKey, isMulti ? sizeKey : null);
        if (partialTargets != null) {
            URLEncoder encoder = context.getURLEncoder();
            FormValueRenderer.addNeededValue(context, formName, partialTargetsKey, encoder.encodeParameter("partial"), null, null);
        }
    }

    private UINode _createRangeNode(UIXRenderingContext context, UINode navBar, String destination, String name, String form, long minValue, long currentValue, int blockSize, long maxValue, String eventKey, String sourceKey, String sizeKey, String partialTargetsKey, String partialTargets) {
        UINode rangeNode = null;
        if (blockSize <= 0 || maxValue < minValue && maxValue != -1L) {
            rangeNode = this._getEmptyRangeNode();
        } else if (!NavigationBarRenderer.supportsScripting(context)) {
            String rangeString = this._getRangeString(context, navBar, currentValue, blockSize, maxValue, null);
            MarlinBean rangeLabel = new MarlinBean("styledText");
            rangeLabel.setAttributeValue(TEXT_ATTR, rangeString);
            rangeLabel.setAttributeValue(STYLE_CLASS_ATTR, "OraNavBarViewOnly");
            rangeNode = rangeLabel;
        } else {
            int count;
            int selectedIndex;
            MarlinBean choice = new MarlinBean("choice");
            choice.setAttributeValue(SHORT_DESC_ATTR, NavigationBarRenderer.getTranslatedValue(context, _CHOICE_TIP_KEY));
            String onChange = null;
            if (form == null) {
                if (this.requiresForm(context) && NavigationBarRenderer.getParentFormName(context) == null) {
                    choice.setAttributeValue(READ_ONLY_ATTR, Boolean.TRUE);
                }
                selectedIndex = this._addNavigationOptions(context, navBar, choice, false, minValue, maxValue, currentValue, blockSize, sizeKey);
                count = choice.getIndexedChildCount(context);
                if (count > 1) {
                    onChange = this._getChoiceOnChange(context, destination, sourceKey, eventKey, name, partialTargets, partialTargetsKey);
                } else {
                    choice.setAttributeValue(READ_ONLY_ATTR, Boolean.TRUE);
                }
            } else {
                selectedIndex = this._addNavigationOptions(context, navBar, choice, true, minValue, maxValue, currentValue, blockSize, sizeKey);
                count = choice.getIndexedChildCount(context);
                if (count > 1) {
                    onChange = this._getChoiceOnChangeFormSubmitted(context, navBar, form, eventKey, sourceKey, name, partialTargetsKey, partialTargets);
                } else {
                    choice.setAttributeValue(READ_ONLY_ATTR, Boolean.TRUE);
                }
            }
            if (onChange != null) {
                choice.setAttributeValue(ON_CHANGE_ATTR, onChange);
                choice.setAttributeValue(ON_FOCUS_ATTR, _CHOICE_FORM_ON_FOCUS);
            }
            if (NavigationBarRenderer.supportsID(context) && selectedIndex >= 0 && !Boolean.TRUE.equals(choice.getAttributeValue(READ_ONLY_ATTR))) {
                String choiceId = XhtmlLafUtils.generateUniqueID(context);
                choice.setID(choiceId);
                StringBuffer text = new StringBuffer(26 + choiceId.length());
                text.append("_setSelectIndexById(\"");
                text.append(choiceId);
                text.append("\",");
                text.append(IntegerUtils.getString((int)selectedIndex));
                text.append(_CHOICE_ON_CHANGE_FORM_END);
                MarlinBean sb = new MarlinBean("script");
                sb.setAttributeValue(TEXT_ATTR, text.toString());
                MarlinBean flb = new MarlinBean("flowLayout");
                flb.addIndexedChild(choice);
                flb.addIndexedChild(sb);
                rangeNode = flb;
            } else {
                rangeNode = choice;
            }
        }
        return rangeNode;
    }

    protected boolean requiresForm(UIXRenderingContext context) {
        return true;
    }

    private int _addNavigationOptions(UIXRenderingContext context, UINode navBar, MarlinBean choice, boolean isForm, long minValue, long maxValue, long value, int blockSize, String sizeKey) {
        long maxBlockIndex;
        int selectedIndex = -1;
        boolean maxUnknown = maxValue == -1L;
        long blockIndex = (value - minValue + (long)blockSize - 1L) / (long)blockSize;
        int offset = (int)(value - (minValue + blockIndex * (long)blockSize));
        if (offset < 0) {
            offset += blockSize;
        }
        if (maxUnknown) {
            maxBlockIndex = blockIndex + 1L;
        } else {
            maxBlockIndex = (maxValue - minValue - (long)offset) / (long)blockSize;
            if (offset > 0) {
                ++maxBlockIndex;
            }
        }
        long firstBlockIndex = maxBlockIndex <= 29L || blockIndex <= 28L ? 0L : (blockIndex - 1L) / 28L * 28L;
        long lastBlockIndex = firstBlockIndex + 29L;
        if (lastBlockIndex > maxBlockIndex) {
            lastBlockIndex = maxBlockIndex;
        }
        Object showAll = navBar.getAttributeValue(context, SHOW_ALL_ATTR);
        boolean atShowAll = "active".equals(showAll);
        if (!maxUnknown && lastBlockIndex > firstBlockIndex && maxBlockIndex <= 29L && (atShowAll || "yes".equals(showAll))) {
            choice.addIndexedChild(0, this._createShowAllOption(context, maxValue, atShowAll));
        } else {
            atShowAll = false;
        }
        DataObject indexNames = (DataObject)navBar.getAttributeValue(context, _INDEX_NAMES_ATTR);
        for (blockIndex = firstBlockIndex; blockIndex <= lastBlockIndex; ++blockIndex) {
            int currentRecordSize;
            long blockStart = minValue + blockIndex * (long)blockSize;
            if (offset > 0) {
                blockStart += (long)(offset - blockSize);
            }
            if (blockStart < minValue) {
                blockStart = minValue;
                currentRecordSize = offset;
            } else {
                currentRecordSize = blockSize;
            }
            Object text = blockIndex == firstBlockIndex && blockIndex != 0L ? NavigationBarRenderer.getTranslatedValue(context, _PREVIOUS_TEXT_KEY) : (blockIndex == lastBlockIndex && (maxUnknown || lastBlockIndex < maxBlockIndex) ? NavigationBarRenderer.getTranslatedValue(context, _MORE_TEXT_KEY) : null);
            MarlinBean currOption = this._createNavigationOption(context, navBar, isForm, blockStart, currentRecordSize, maxValue, atShowAll ? minValue - 1L : value, sizeKey, text, indexNames);
            choice.addIndexedChild(currOption);
            if (!Boolean.TRUE.equals(currOption.getAttributeValue(SELECTED_ATTR))) continue;
            selectedIndex = choice.getIndexedChildCount(context) - 1;
        }
        return selectedIndex;
    }

    private UINode _createShowAllOption(UIXRenderingContext context, long maxValue, boolean atShowAll) {
        MarlinBean option = new MarlinBean("option");
        option.setAttributeValue(VALUE_ATTR, "all");
        String[] parameters = new String[]{IntegerUtils.getString((long)maxValue)};
        String showAllText = this.formatString(context, NavigationBarRenderer.getTranslatedString(context, _SHOW_ALL_KEY), parameters);
        option.setAttributeValue(TEXT_ATTR, showAllText);
        if (atShowAll) {
            option.setAttributeValue(SELECTED_ATTR, Boolean.TRUE);
        }
        return option;
    }

    private MarlinBean _createNavigationOption(UIXRenderingContext context, UINode navBar, boolean isForm, long blockStart, int blockSize, long maxValue, long currValue, String sizeKey, Object text, DataObject indexNames) {
        int actualBlockSize;
        MarlinBean option = new MarlinBean("option");
        if (text == null) {
            text = this._getRangeString(context, navBar, blockStart, blockSize, maxValue, indexNames);
        }
        option.setAttributeValue(TEXT_ATTR, text);
        if (maxValue == -1L) {
            actualBlockSize = blockSize;
        } else {
            actualBlockSize = (int)(maxValue - blockStart + 1L);
            if (actualBlockSize > blockSize) {
                actualBlockSize = blockSize;
            }
        }
        option.setAttributeValue(VALUE_ATTR, this._getMultiDestinationURLEnd(blockStart, sizeKey, actualBlockSize, isForm));
        if (currValue >= blockStart && currValue < blockStart + (long)blockSize) {
            option.setAttributeValue(SELECTED_ATTR, Boolean.TRUE);
        }
        return option;
    }

    protected boolean disabledNavigationShown(UIXRenderingContext context) {
        return true;
    }

    private String _getMultiSubmitButtonText(UIXRenderingContext context, boolean isBack, int size) {
        boolean isRTL = NavigationBarRenderer.isRightToLeft(context);
        char arrowChar = isBack ^ isRTL ? (char)'<' : '>';
        String blockText = this.getBlockString(context, isBack, size);
        StringBuffer buttonText = new StringBuffer(blockText.length() + 2);
        if (isBack) {
            buttonText.append(arrowChar);
            buttonText.append('\u00a0');
            buttonText.append(blockText);
        } else {
            buttonText.append(blockText);
            buttonText.append('\u00a0');
            buttonText.append(arrowChar);
        }
        return buttonText.toString();
    }

    public static UINode createSubmitButton(UIXRenderingContext context, Object buttonText, Object buttonAccessKey, String buttonID, String formName, boolean validate, String eventKey, String sourceKey, String source, String valueKey, long value, String sizeKey, int size) {
        MarlinBean submitButton = new MarlinBean("submitButton");
        submitButton.setID(buttonID);
        submitButton.setAttributeValue(FORM_NAME_ATTR, formName);
        submitButton.setAttributeValue(UNVALIDATED_ATTR, !validate);
        submitButton.setAttributeValue(TEXT_ATTR, buttonText);
        submitButton.setAttributeValue(ACCESS_KEY_ATTR, buttonAccessKey);
        submitButton.setAttributeValue(NAME_VALUES_ATTR, NavigationBarRenderer._createKeyValueArray(eventKey, sourceKey, source, valueKey, value, sizeKey, size, null, null));
        return submitButton;
    }

    private UINode _createTextLink(UIXRenderingContext context, UINode navBar, boolean isBack, String destination, String onClick, int records) {
        String linkID;
        MarlinBean link;
        String text = this.getBlockString(context, isBack, records);
        if (records > 0) {
            link = new MarlinBean("link");
            link.setAttributeValue(DESTINATION_ATTR, destination);
            link.setAttributeValue(ON_CLICK_ATTR, onClick);
            link.setAttributeValue(STYLE_CLASS_ATTR, "OraNavBarActiveLink");
        } else {
            link = new MarlinBean("styledText");
            link.setAttributeValue(STYLE_CLASS_ATTR, "OraNavBarInactiveLink");
        }
        link.setAttributeValue(TEXT_ATTR, text);
        if (!isBack && (linkID = this._getIDForFocus(context, navBar)) != null) {
            link.setID(linkID);
        }
        return link;
    }

    protected String getIconURI(UIXRenderingContext context, boolean isBack, boolean isEnabled) {
        String iconName = isBack ? (isEnabled ? "af|table::prev-icon" : "af|table::prev-disabled-icon") : (isEnabled ? "af|table::next-icon" : "af|table::next-disabled-icon");
        Skin skin = context.getSkin();
        RenderingContext arc = RenderingContext.getCurrentInstance();
        FacesContext fContext = context.getFacesContext();
        String iconURI = (String)skin.getIcon(iconName).getImageURI(fContext, arc);
        return iconURI;
    }

    private UINode _createArrowImage(UIXRenderingContext context, boolean isBack, String destination, String onClick) {
        boolean isEnabled = destination != null;
        String iconURI = this.getIconURI(context, isBack, isEnabled);
        if (iconURI == null) {
            return null;
        }
        String shortDesKey = isBack ? (isEnabled ? _PREVIOUS_DESC_KEY : _DISABLED_PREVIOUS_DESC_KEY) : (isEnabled ? _NEXT_DESC_KEY : _DISABLED_NEXT_DESC_KEY);
        MarlinBean arrow = new MarlinBean("image");
        arrow.setAttributeValue(SOURCE_ATTR, iconURI);
        arrow.setAttributeValue(SHORT_DESC_ATTR, NavigationBarRenderer.getTranslatedValue(context, shortDesKey));
        if (destination != null) {
            arrow.setAttributeValue(DESTINATION_ATTR, destination);
            arrow.setOnClick(onClick);
        }
        return arrow;
    }

    protected String getBlockString(UIXRenderingContext context, boolean isBack, int numRecords) {
        if (numRecords > 0) {
            String pattern = isBack ? NavigationBarRenderer.getTranslatedString(context, _SELECT_RANGE_PREVIOUS_KEY) : NavigationBarRenderer.getTranslatedString(context, _SELECT_RANGE_NEXT_KEY);
            String value = IntegerUtils.getString((int)numRecords);
            String[] parameters = new String[]{value};
            return this.formatString(context, pattern, parameters);
        }
        String text = isBack ? NavigationBarRenderer.getTranslatedString(context, _SELECT_RANGE_DISABLED_PREVIOUS_KEY) : NavigationBarRenderer.getTranslatedString(context, _SELECT_RANGE_DISABLED_NEXT_KEY);
        return text;
    }

    private String _getRangeString(UIXRenderingContext context, UINode node, long start, int visibleItemCount, long total, DataObject indexNames) {
        String[] parameters;
        String pattern;
        if (visibleItemCount == -1) {
            Object typeText = node.getAttributeValue(context, TYPE_TEXT_ATTR);
            if (typeText == null) {
                typeText = NavigationBarRenderer.getTranslatedString(context, _STEP_TEXT_KEY);
            }
            if (total == -1L) {
                pattern = NavigationBarRenderer.getTranslatedString(context, _SINGLE_RANGE_FORMAT_NO_TOTAL_STRING);
                parameters = new String[]{typeText.toString(), IntegerUtils.getString((long)start)};
            } else {
                pattern = NavigationBarRenderer.getTranslatedString(context, _SINGLE_RANGE_FORMAT_TOTAL_STRING);
                parameters = new String[]{typeText.toString(), IntegerUtils.getString((long)start), IntegerUtils.getString((long)total)};
            }
        } else {
            long currVisible;
            long l = currVisible = total == -1L ? (long)visibleItemCount : total - start + 1L;
            if (currVisible > (long)visibleItemCount) {
                currVisible = visibleItemCount;
            }
            if (indexNames != null) {
                Long startNum = start;
                Long endNum = start + currVisible - 1L;
                Object o = indexNames.selectValue(context, startNum);
                String startParam = o != null ? o.toString() : startNum.toString();
                o = indexNames.selectValue(context, endNum);
                String endParam = o != null ? o.toString() : endNum.toString();
                pattern = NavigationBarRenderer.getTranslatedString(context, _STRING_RANGE_FORMAT_STRING);
                parameters = new String[]{startParam, endParam};
            } else {
                String startParam = IntegerUtils.getString((long)start);
                String endParam = IntegerUtils.getString((long)(start + currVisible - 1L));
                if (total == -1L) {
                    pattern = NavigationBarRenderer.getTranslatedString(context, _MULTI_RANGE_FORMAT_NO_TOTAL_STRING);
                    parameters = new String[]{startParam, endParam};
                } else {
                    pattern = NavigationBarRenderer.getTranslatedString(context, _MULTI_RANGE_FORMAT_TOTAL_STRING);
                    parameters = new String[]{startParam, endParam, IntegerUtils.getString((long)total)};
                }
            }
        }
        return this.formatString(context, pattern, parameters);
    }

    public static String getSingleDestinationURL(UIXRenderingContext context, UINode node, String eventKey, String sourceKey, String name, String valueKey, long value) {
        String baseURL = NavigationBarRenderer._getDestinationString(context, node);
        String[] keysAndValues = new String[]{eventKey, "goto", sourceKey, name, valueKey, IntegerUtils.getString((long)value)};
        return NavigationBarRenderer.appendURLArguments(baseURL, keysAndValues);
    }

    public static String getSingleDestinationSubmit(UIXRenderingContext context, UINode node, String form, String name, long value, boolean doValidate) {
        URLEncoder urlEncoder = context.getURLEncoder();
        String eventKey = urlEncoder.encodeParameter("event");
        String sourceKey = urlEncoder.encodeParameter("source");
        String valueKey = urlEncoder.encodeParameter("value");
        return NavigationBarRenderer.getSingleDestinationSubmit(context, node, form, eventKey, sourceKey, name, valueKey, value, doValidate);
    }

    public static String getSingleDestinationSubmit(UIXRenderingContext context, UINode node, String form, String eventKey, String sourceKey, String name, String valueKey, long value, boolean doValidate) {
        String valueString = IntegerUtils.getString((long)value);
        FormEncoder formEncoder = context.getFormEncoder();
        String encodedGotoEvent = XhtmlLafUtils.getFormEncodedParameter(formEncoder, form, eventKey, "goto");
        String encodedSource = XhtmlLafUtils.getFormEncodedParameter(formEncoder, form, sourceKey, name);
        String encodedValue = XhtmlLafUtils.getFormEncodedParameter(formEncoder, form, valueKey, valueString);
        if (form == null) {
            form = "";
        }
        if (encodedSource == null) {
            encodedSource = "";
        }
        boolean validate = false;
        if (doValidate) {
            validate = NavigationBarRenderer._doValidate(context, node);
        }
        int bufferSize = _LINK_ON_CHANGE_FORM_START.length() + form.length() + 25 + encodedGotoEvent.length() + encodedSource.length() + encodedValue.length();
        StringBuffer buffer = new StringBuffer(bufferSize);
        buffer.append(_LINK_ON_CHANGE_FORM_START);
        buffer.append(form);
        buffer.append("','");
        buffer.append(encodedGotoEvent);
        buffer.append("','");
        buffer.append(encodedSource);
        if (validate) {
            buffer.append("',1,'");
        } else {
            buffer.append("',0,'");
        }
        buffer.append(encodedValue);
        buffer.append("');return false");
        return buffer.toString();
    }

    private String _getMultiDestinationSubmit(UIXRenderingContext context, String form, String eventKey, String sourceKey, String name, String valueKey, long value, String sizeKey, int size, boolean validate, String partialTargetsKey, String partialTargets) {
        String valueString = IntegerUtils.getString((long)value);
        String sizeString = IntegerUtils.getString((int)size);
        FormEncoder formEncoder = context.getFormEncoder();
        String encodedGotoEvent = XhtmlLafUtils.getFormEncodedParameter(formEncoder, form, eventKey, "goto");
        String encodedSource = XhtmlLafUtils.getFormEncodedParameter(formEncoder, form, sourceKey, name);
        String encodedValue = XhtmlLafUtils.getFormEncodedParameter(formEncoder, form, valueKey, valueString);
        String encodedSize = XhtmlLafUtils.getFormEncodedParameter(formEncoder, form, sizeKey, sizeString);
        String encodedPartialTargets = XhtmlLafUtils.getFormEncodedParameter(formEncoder, form, partialTargetsKey, partialTargets);
        int bufferSize = _LINK_ON_CHANGE_FORM_START.length() + form.length() + 34 + encodedGotoEvent.length() + encodedSource.length() + encodedValue.length() + encodedSize.length();
        if (partialTargets != null) {
            bufferSize += partialTargets.length() + 2;
        }
        StringBuffer buffer = new StringBuffer(bufferSize);
        buffer.append(_LINK_ON_CHANGE_FORM_START);
        buffer.append(form);
        buffer.append("', '");
        buffer.append(encodedGotoEvent);
        buffer.append("', '");
        buffer.append(encodedSource);
        if (validate) {
            buffer.append("',1,'");
        } else {
            buffer.append("',0,'");
        }
        buffer.append(encodedValue);
        buffer.append("', '");
        buffer.append(encodedSize);
        buffer.append("',");
        if (encodedPartialTargets != null) {
            buffer.append("'");
            buffer.append(encodedPartialTargets);
            buffer.append("'");
        } else {
            buffer.append("null");
        }
        buffer.append(");return false");
        return buffer.toString();
    }

    private static String[] _createKeyValueArray(String eventKey, String sourceKey, String source, String valueKey, long value, String sizeKey, int size, String partialTargetsKey, String partialTargets) {
        int length = 8;
        if (partialTargets != null) {
            length += 2;
        }
        String[] keyValues = new String[length];
        keyValues[0] = eventKey;
        keyValues[1] = "goto";
        keyValues[2] = sourceKey;
        keyValues[3] = source;
        keyValues[4] = valueKey;
        keyValues[5] = IntegerUtils.getString((long)value);
        keyValues[6] = sizeKey;
        keyValues[7] = IntegerUtils.getString((int)size);
        if (partialTargets != null) {
            keyValues[8] = partialTargetsKey;
            keyValues[9] = partialTargets;
        }
        return keyValues;
    }

    private String _getMultiDestinationURL(String baseURL, String eventKey, String sourceKey, String source, String valueKey, long value, String sizeKey, String partialTargetsKey, int size, String partialTargets) {
        return NavigationBarRenderer.appendURLArguments(baseURL, NavigationBarRenderer._createKeyValueArray(eventKey, sourceKey, source, valueKey, value, sizeKey, size, partialTargetsKey, partialTargets));
    }

    private String _getMultiDestinationURLEnd(long value, String sizeKey, int size, boolean isForm) {
        String valueString = IntegerUtils.getString((long)value);
        String sizeString = IntegerUtils.getString((int)size);
        int bufferSize = valueString.length() + sizeKey.length() + 2 + sizeString.length();
        StringBuffer buffer = new StringBuffer(bufferSize);
        buffer.append(valueString);
        if (isForm) {
            buffer.append(",");
        } else {
            buffer.append('&');
            buffer.append(sizeKey);
            buffer.append('=');
        }
        buffer.append(sizeString);
        return buffer.toString();
    }

    private UINode _getEmptyRangeNode() {
        if (_sEmptyRangeNode == null) {
            _sEmptyRangeNode = new TextNode(NBSP_STRING);
        }
        return _sEmptyRangeNode;
    }

    private static String _getNavBarSubmitScript(String eventKey, String sourceKey, String valueKey, String sizeKey, String partialTargetsKey) {
        int len = _NAVBAR_SUBMIT_SCRIPT_LENGTH + eventKey.length() + sourceKey.length() + valueKey.length() + sizeKey.length();
        StringBuffer buf = new StringBuffer(len);
        buf.append(_NAVBAR_SUBMIT_SCRIPT[0]);
        buf.append(eventKey);
        buf.append(_NAVBAR_SUBMIT_SCRIPT[1]);
        buf.append(sourceKey);
        buf.append(_NAVBAR_SUBMIT_SCRIPT[2]);
        buf.append(valueKey);
        buf.append(_NAVBAR_SUBMIT_SCRIPT[3]);
        buf.append(sizeKey);
        buf.append(_NAVBAR_SUBMIT_SCRIPT[4]);
        buf.append(partialTargetsKey);
        buf.append(_NAVBAR_SUBMIT_SCRIPT[5]);
        return buf.toString();
    }

    private boolean _renderAsTable(UIXRenderingContext context, UINode navBar) {
        UIComponent component = NodeUtils.getUIComponent(context, navBar);
        return !(component.getParent() instanceof CorePanelButtonBar);
    }

    private static boolean _doValidate(UIXRenderingContext context, UINode navBar) {
        return !Boolean.TRUE.equals(navBar.getAttributeValue(context, UNVALIDATED_ATTR));
    }

    protected void renderItemSpacer(UIXRenderingContext context) throws IOException {
        char[] chars = new char[]{'\u00a0'};
        context.getResponseWriter().writeText(chars, 0, 1);
    }

    private void _renderSpacerCell(UIXRenderingContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        this.renderItemSpacer(context);
        writer.endElement("td");
    }

    private void _renderStartTableCell(UIXRenderingContext context, UINode node, ResponseWriter writer, boolean renderAsTable, boolean isBaseID) throws IOException {
        writer.startElement("td", null);
        if (!renderAsTable && isBaseID) {
            this.renderID(context, node);
        }
    }

    private static String _getPartialTargets(UIXRenderingContext context, UINode node) {
        if (!NavigationBarRenderer.supportsPartialRendering(context)) {
            return null;
        }
        String[] partialTargets = (String[])node.getAttributeValue(context, PARTIAL_TARGETS_ATTR);
        return PartialPageRendererUtils.encodePartialTargets(partialTargets);
    }

    private String _getIDForFocus(UIXRenderingContext context, UINode navBar) {
        String id = null;
        Object initialFocusID = NavigationBarRenderer.getRenderingProperty(context, INITIAL_FOCUS_CONTEXT_PROPERTY);
        if (initialFocusID != null) {
            Object navBarID;
            Object object = navBarID = NavigationBarRenderer.supportsID(context) ? this.getID(context, navBar) : null;
            if (initialFocusID.equals(navBarID)) {
                String focus = "-focus";
                StringBuffer buffer = new StringBuffer(navBarID.toString().length() + focus.length());
                buffer.append(navBarID.toString());
                buffer.append(focus);
                id = buffer.toString();
                NavigationBarRenderer.setRenderingProperty(context, INITIAL_FOCUS_CONTEXT_PROPERTY, id);
            }
        }
        return id;
    }

    static {
        _NAVBAR_SUBMIT_SCRIPT = new String[]{"function _navBarSubmit(formName, event, navBar, vld, val, sze, partialTargets){var i = val.indexOf(',');if (i >= 0){sze = val.substring(i+1);val = val.substring(0, i);}var submitFunc = (partialTargets == (void 0)) ? submitForm : _submitPartialChange;return submitFunc(formName,vld,{", ":event,", ":navBar,", ":val,", ":sze,", ":partialTargets});}"};
        _NAVBAR_SUBMIT_SCRIPT_LENGTH = XhtmlLafUtils.getLength(_NAVBAR_SUBMIT_SCRIPT);
        _INDEX_NAMES_ATTR = AttributeKey.getAttributeKey("indexNames");
    }
}

