/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.nav.CoreGoButton;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.util.StringUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.AccessKeyUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.GoLinkRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

public class GoButtonRenderer
extends GoLinkRenderer {
    private PropertyKey _iconKey;
    private static final List<String> _DISABLED_STATE_LIST = Collections.singletonList("p_AFDisabled");

    public GoButtonRenderer() {
        this(CoreGoButton.TYPE);
    }

    protected GoButtonRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._iconKey = type.findKey("icon");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        char accessKey;
        String element;
        String clientId = component.getClientId(context);
        if (this.canSkipRendering(rc, clientId)) {
            return;
        }
        assert (rc.getCurrentClientId() == null);
        rc.setCurrentClientId(clientId);
        boolean useButton = false;
        boolean useInput = false;
        boolean supportScriptEvents = false;
        boolean imageLink = false;
        boolean iconAvailable = false;
        String icon = this.getIcon(component, bean);
        if (icon != null) {
            iconAvailable = true;
        }
        if (GoButtonRenderer.supportsScripting(rc) && GoButtonRenderer.supportsIntrinsicEvents(rc)) {
            supportScriptEvents = true;
        }
        if (supportScriptEvents) {
            if (GoButtonRenderer.supportsAdvancedForms(rc)) {
                element = "button";
                useButton = true;
            } else if (iconAvailable && !GoButtonRenderer.supportsOnClickOnImgInput(rc)) {
                element = "a";
                imageLink = true;
            } else {
                element = "input";
                useInput = true;
            }
        } else {
            element = "a";
        }
        ResponseWriter rw = context.getResponseWriter();
        boolean disabled = this.getDisabled(component, bean);
        rw.startElement(element, component);
        this.renderId(context, component);
        if (supportScriptEvents) {
            if (useInput && iconAvailable) {
                rw.writeAttribute("type", (Object)"image", null);
            } else if (!imageLink) {
                rw.writeAttribute("type", (Object)"button", null);
            }
            if (!imageLink && disabled) {
                rw.writeAttribute("disabled", (Object)Boolean.TRUE, "disabled");
            }
        }
        if (disabled || !GoButtonRenderer.supportsNavigation(rc)) {
            this.renderStyleAttributes(context, rc, component, bean);
        } else {
            this.renderAllAttributes(context, rc, component, bean);
            if (supportScriptEvents) {
                rw.writeAttribute("onclick", (Object)this.getButtonOnclick(component, bean), null);
                if (imageLink) {
                    this.renderEncodedActionURI(context, "href", "#");
                }
            } else {
                this.renderEncodedActionURI(context, "href", this.getDestination(component, bean));
                if (GoButtonRenderer.supportsTarget(rc)) {
                    rw.writeAttribute("target", (Object)this.getTargetFrame(component, bean), null);
                }
            }
        }
        if (GoButtonRenderer.supportsAccessKeys(rc)) {
            accessKey = this.getAccessKey(component, bean);
            if (accessKey != '\uffff') {
                rw.writeAttribute("accesskey", (Object)Character.valueOf(accessKey), "accessKey");
            }
        } else {
            accessKey = '\uffff';
        }
        String text = this.getText(component, bean);
        if (useButton) {
            AccessKeyUtils.renderAccessKeyText(context, (Object)text, accessKey, "AFAccessKeyStyle");
            if (icon != null) {
                OutputUtils.renderImage(context, rc, icon, null, null, null, this.getShortDesc(component, bean));
            }
        } else if (!supportScriptEvents) {
            if (iconAvailable) {
                OutputUtils.renderImage(context, rc, icon, null, null, null, this.getShortDesc(component, bean));
            } else {
                AccessKeyUtils.renderAccessKeyText(context, (Object)text, accessKey, "AFAccessKeyStyle");
            }
        } else if (imageLink) {
            OutputUtils.renderImage(context, rc, icon, null, null, null, this.getShortDesc(component, bean));
        } else if (iconAvailable) {
            this.renderEncodedResourceURI(context, "src", icon);
        } else {
            rw.writeAttribute("value", (Object)text, "text");
        }
        rw.endElement(element);
        rc.setCurrentClientId(null);
    }

    protected List<String> getStateStyleClasses(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) {
        if (this.getDisabled(component, bean)) {
            return _DISABLED_STATE_LIST;
        }
        return null;
    }

    @Override
    protected void renderStyleAttributes(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, String defaultStyleClass) throws IOException {
        String styleClass = this.getStyleClass(component, bean);
        List<String> stateStyleClasses = this.getStateStyleClasses(context, rc, component, bean);
        if (styleClass == null && defaultStyleClass != null && stateStyleClasses == null) {
            GoButtonRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)defaultStyleClass);
        } else {
            int numStates;
            int numClasses = (styleClass != null ? 1 : 0) + (defaultStyleClass != null ? 1 : 0) + (numStates = stateStyleClasses != null ? stateStyleClasses.size() : 0);
            if (numClasses > 0) {
                String[] styleClasses = new String[numClasses];
                int i = 0;
                if (styleClass != null) {
                    styleClasses[i++] = styleClass;
                }
                if (defaultStyleClass != null) {
                    styleClasses[i++] = defaultStyleClass;
                }
                int j = 0;
                while (j < numStates) {
                    styleClasses[i] = stateStyleClasses.get(j);
                    ++j;
                    ++i;
                }
                GoButtonRenderer.renderStyleClasses((FacesContext)context, (RenderingContext)rc, (String[])styleClasses);
            }
        }
        String style = this.getInlineStyle(component, bean);
        if (style != null) {
            context.getResponseWriter().writeAttribute("style", (Object)style, "inlineStyle");
        }
    }

    @Override
    protected String getOnclick(UIComponent component, FacesBean bean) {
        return null;
    }

    protected String getButtonOnclick(UIComponent component, FacesBean bean) {
        String base = super.getOnclick(component, bean);
        String destination = this.getDestination(component, bean);
        if (destination == null) {
            return base;
        }
        destination = FacesContext.getCurrentInstance().getExternalContext().encodeActionURL(destination);
        String onclickJS = null;
        if (destination.length() > 11 && "javascript:".equalsIgnoreCase(destination.substring(0, 11))) {
            onclickJS = destination.substring(11);
        } else {
            destination = StringUtils.replace((String)destination, (String)"'", (String)"\\'");
            String targetFrame = this.getTargetFrame(component, bean);
            onclickJS = targetFrame != null && !"_self".equals(targetFrame) ? ("_top".equals(targetFrame) ? "top.location='" + destination + "'" : ("_parent".equals(targetFrame) ? "parent.location='" + destination + "'" : ("_blank".equals(targetFrame) || "_new".equals(targetFrame) ? "window.open('" + destination + "')" : "top[" + targetFrame + "].location='" + destination + "'"))) : "document.location='" + destination + "'";
        }
        return XhtmlUtils.getChainedJS(base, onclickJS, true);
    }

    @Override
    protected String getDefaultStyleClass(UIComponent component, FacesBean bean) {
        return "af|goButton";
    }

    protected String getIcon(UIComponent component, FacesBean bean) {
        return GoButtonRenderer.toResourceUri((FacesContext)FacesContext.getCurrentInstance(), (Object)bean.getProperty(this._iconKey));
    }
}

