export declare function isFile(file: string): boolean;
export declare function isDir(path: string): boolean;
export declare function deriveRootDir(globPaths: string[]): string;
/**
 * Get the longest directory path common to all files.
 */
export declare function getCommonDirectory(files: readonly string[]): string;
/**
 * Load the given file and return its contents.
 *
 * @param file  The path of the file to read.
 * @returns The files contents.
 */
export declare function readFile(file: string): string;
/**
 * Write a file to disc.
 *
 * If the containing directory does not exist it will be created.
 *
 * @param fileName  The name of the file that should be written.
 * @param data  The contents of the file.
 */
export declare function writeFileSync(fileName: string, data: string): void;
/**
 * Write a file to disc.
 *
 * If the containing directory does not exist it will be created.
 *
 * @param fileName  The name of the file that should be written.
 * @param data  The contents of the file.
 */
export declare function writeFile(fileName: string, data: string): Promise<void>;
/**
 * Copy a file or directory recursively.
 */
export declare function copy(src: string, dest: string): Promise<void>;
export declare function copySync(src: string, dest: string): void;
/**
 * Simpler version of `glob.sync` that only covers our use cases, always ignoring node_modules.
 */
export declare function glob(pattern: string, root: string, options?: {
    includeDirectories?: boolean;
    followSymlinks?: boolean;
}): string[];
export declare function hasTsExtension(path: string): boolean;
export declare function discoverInParentDir<T extends {}>(name: string, dir: string, read: (content: string) => T | undefined): {
    file: string;
    content: T;
} | undefined;
export declare function discoverInParentDirExactMatch<T extends {}>(name: string, dir: string, read: (content: string) => T | undefined): {
    file: string;
    content: T;
} | undefined;
export declare function discoverPackageJson(dir: string): {
    file: string;
    content: {
        version?: string | undefined;
    } & {
        name: string;
    };
} | undefined;
export declare function findPackageForPath(sourcePath: string): string | undefined;
