/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.view.facelets.tag.jstl.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * Holds the iteration state generated by c:forEach tag.
 */
public class IterationState implements Serializable
{
    /**
     * This counter is used to generate an unique base per element
     * in the collection that will be used later in the id
     * generation algorithm.
     */
    private int counter;
    
    private List<Object[]> valueList;
    
    public IterationState()
    {
        this.valueList = new ArrayList<Object[]>();
    }

    public List<Object[]> getValueList()
    {
        return valueList;
    }

    public void setValueList(List<Object[]> valueList)
    {
        this.valueList = valueList;
    }

    public int getCounter()
    {
        return counter;
    }

    public void setCounter(int counter)
    {
        this.counter = counter;
    }
    
    public Iterator getIterator()
    {
        return new IteratorWrapper(valueList.iterator());
    }

    private static class IteratorWrapper implements Iterator
    {
        private Iterator<Object[]> delegate;

        public IteratorWrapper(Iterator<Object[]> delegate)
        {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext()
        {
            return delegate.hasNext();
        }

        @Override
        public Object next()
        {
            return delegate.next()[1];
        }

        @Override
        public void remove()
        {
            delegate.remove();
        }
    }
}
