/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.websvc.core.dev.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.border.EtchedBorder;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.openide.explorer.view.BeanTreeView;

import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.NbBundle;

public class EjbChooser extends javax.swing.JPanel {
    
    public static final String IS_VALID = "ejbChooser_isValid"; //NOI18N
    
    private NodeAcceptor nodeAcceptor;
    private NodeDisplayPanel nodeDisplayPanel;
    
    /** Creates new form EjbChooser */
    public EjbChooser(Node root, boolean localInterfaceOptional) {
        initComponents();

        this.nodeAcceptor = new NodeAcceptorImpl(localInterfaceOptional);

        nodeDisplayPanel = new NodeDisplayPanel(root);
        nodeDisplayPanel.setBorder(new EtchedBorder());
        jPanelBeanTree.add(nodeDisplayPanel);
        nodeDisplayPanel.addPropertyChangeListener(new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent pce) {
                validateNodes();
            }
        });

        BeanTreeView btw = (BeanTreeView)nodeDisplayPanel.getComponent(0);
        jLabelDesc.setLabelFor(btw.getViewport().getView());

        validateNodes();
    }
    
    private void validateNodes() {
        boolean nodeAccepted = nodeAcceptor.acceptNodes(nodeDisplayPanel.getSelectedNodes());
        if (!nodeAccepted)
            firePropertyChange(IS_VALID, true, false);
        else
            firePropertyChange(IS_VALID, false, true);
    }

    private void setErrorMessage(String message) {
        if (message == null)
            message = " ";
        jLabelError.setText(message);
    }
    
    public Node[] getSelectedNodes() {
        return nodeDisplayPanel.getSelectedNodes();
    }

    public String getSelectedEJBProjectName() {
        return nodeDisplayPanel.getSelectedNodes()[0].getParentNode().getDisplayName();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabelDesc = new javax.swing.JLabel();
        jPanelBeanTree = new javax.swing.JPanel();
        jLabelError = new javax.swing.JLabel();

        setToolTipText(org.openide.util.NbBundle.getMessage(EjbChooser.class, "LBL_BrowseBean_Title")); // NOI18N
        setLayout(new java.awt.GridBagLayout());

        jLabelDesc.setLabelFor(jPanelBeanTree);
        org.openide.awt.Mnemonics.setLocalizedText(jLabelDesc, org.openide.util.NbBundle.getMessage(EjbChooser.class, "LBL_SelectBeanDescription")); // NOI18N
        jLabelDesc.setToolTipText(org.openide.util.NbBundle.getMessage(EjbChooser.class, "HINT_EnterpriseBean")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(11, 11, 0, 11);
        add(jLabelDesc, gridBagConstraints);

        jPanelBeanTree.setLayout(new java.awt.BorderLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(11, 11, 11, 11);
        add(jPanelBeanTree, gridBagConstraints);

        jLabelError.setForeground(new java.awt.Color(255, 0, 0));
        jLabelError.setLabelFor(jPanelBeanTree);
        jLabelError.setText(" ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 11, 0, 11);
        add(jLabelError, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents
        
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabelDesc;
    private javax.swing.JLabel jLabelError;
    private javax.swing.JPanel jPanelBeanTree;
    // End of variables declaration//GEN-END:variables
    
    private class NodeAcceptorImpl implements NodeAcceptor {
        private boolean localInterfaceOptional;

        public NodeAcceptorImpl(boolean localInterfaceOptional) {
            this.localInterfaceOptional = localInterfaceOptional;
        }
    
        public boolean acceptNodes(Node[] nodes) {
            setErrorMessage(" "); //NOI18N

            // no node selected
            if (nodes.length == 0) {
                setErrorMessage(NbBundle.getMessage(EjbChooser.class, "LBL_SelectOneEJB"));
                return false;
            }
            
            EjbReference ejbRef = nodes[0].getLookup().lookup(EjbReference.class);
            
            if (ejbRef == null) {
                setErrorMessage(NbBundle.getMessage(EjbChooser.class, "LBL_NodeIsNotEJB"));
                return false;                
            }
            
            if (ejbRef.getLocal() == null && ejbRef.getRemote() == null && !localInterfaceOptional) {
                setErrorMessage(NbBundle.getMessage(EjbChooser.class,"MSG_MISSING_INTERFACE")); 
                return false;
            }
            
            return true;
        }
    }

}
