/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.libs.git.jgit;

import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;

/**
 *
 * @author ondra
 */
public class ProtocolsTestSuite extends AbstractGitTestCase {
    private Repository repository;
    private File workDir;

    public ProtocolsTestSuite (String testName) throws IOException {
        super(testName);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        workDir = getWorkingDirectory();
        repository = getRepository(getLocalGitRepository());
    }
    
    public void testFtpProtocol () throws Exception {
        Transport t = Transport.open(repository, new URIish("ftp://ftphost/abc"));
        try {
            t.openFetch();
            fail("JGit ftp support fixed, fix #200693 workaround");
            // ftp support fixed, wa in TransportCommand.openTransport should be removed 
        } catch (ClassCastException ex) {
            // jgit has a bug that prevents from using ftp protocol
        }
    }
}
