/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.maven.hints.pom;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.GroupLayout.Alignment;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle.ComponentPlacement;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/**
 *
 * @author mkleint
 */
public class JavaNetRepositoryErrorCustomizer extends javax.swing.JPanel {
    private final Preferences preferences;
    private final Map<String, Object> id2Saved = new HashMap<>();

    /** Creates new form ReleaseVersionErrorCustomizer */
    public JavaNetRepositoryErrorCustomizer(Preferences prefs) {
        initComponents();
        this.preferences = prefs;
        boolean selected = preferences.getBoolean(JavaNetRepositoryError.PROP_SELECTED, true);
        rbSelected.setSelected(selected);
        rbAny.setSelected(!selected);
        String values = preferences.get(JavaNetRepositoryError.PROP_URLS, JavaNetRepositoryError.DEFAULT_URLS);
        String[] vals = values.split("([\\s])+");
        StringBuilder sb = new StringBuilder();
        for (String v : vals) {
            sb.append(v.trim()).append("\n");
        }
        taSelected.setText(sb.toString());
        if (rbAny.isSelected()) {
            taSelected.setEnabled(false);
        }
        id2Saved.put(JavaNetRepositoryError.PROP_SELECTED, selected);
        id2Saved.put(JavaNetRepositoryError.PROP_URLS, values);
    }
    
    String getSavedValue(String key) {
        return id2Saved.get(key).toString();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new ButtonGroup();
        rbAny = new JRadioButton();
        rbSelected = new JRadioButton();
        jScrollPane1 = new JScrollPane();
        taSelected = new JTextArea();
        jLabel1 = new JLabel();

        buttonGroup1.add(rbAny);
        Mnemonics.setLocalizedText(rbAny, NbBundle.getMessage(JavaNetRepositoryErrorCustomizer.class, "JavaNetRepositoryErrorCustomizer.rbAny.text")); // NOI18N
        rbAny.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                rbAnyActionPerformed(evt);
            }
        });

        buttonGroup1.add(rbSelected);
        Mnemonics.setLocalizedText(rbSelected, NbBundle.getMessage(JavaNetRepositoryErrorCustomizer.class, "JavaNetRepositoryErrorCustomizer.rbSelected.text")); // NOI18N
        rbSelected.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                rbSelectedActionPerformed(evt);
            }
        });

        taSelected.setColumns(20);
        taSelected.setRows(5);
        taSelected.addKeyListener(new KeyAdapter() {
            public void keyReleased(KeyEvent evt) {
                taSelectedKeyReleased(evt);
            }
        });
        jScrollPane1.setViewportView(taSelected);

        Mnemonics.setLocalizedText(jLabel1, NbBundle.getMessage(JavaNetRepositoryErrorCustomizer.class, "JavaNetRepositoryErrorCustomizer.jLabel1.text")); // NOI18N
        jLabel1.setToolTipText(NbBundle.getMessage(JavaNetRepositoryErrorCustomizer.class, "JavaNetRepositoryErrorCustomizer.jLabel1.toolTipText")); // NOI18N

        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(Alignment.LEADING)
                    .addComponent(jScrollPane1)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(Alignment.LEADING)
                            .addComponent(rbAny)
                            .addComponent(rbSelected)
                            .addComponent(jLabel1))
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(layout.createParallelGroup(Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(rbAny)
                .addPreferredGap(ComponentPlacement.UNRELATED)
                .addComponent(rbSelected)
                .addPreferredGap(ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, GroupLayout.DEFAULT_SIZE, 103, Short.MAX_VALUE)
                .addPreferredGap(ComponentPlacement.RELATED)
                .addComponent(jLabel1)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void rbAnyActionPerformed(ActionEvent evt) {//GEN-FIRST:event_rbAnyActionPerformed
        preferences.putBoolean(JavaNetRepositoryError.PROP_SELECTED, false);
        taSelected.setEnabled(false);
    }//GEN-LAST:event_rbAnyActionPerformed

    private void rbSelectedActionPerformed(ActionEvent evt) {//GEN-FIRST:event_rbSelectedActionPerformed
        preferences.putBoolean(JavaNetRepositoryError.PROP_SELECTED, true);
        taSelected.setEnabled(true);
    }//GEN-LAST:event_rbSelectedActionPerformed

    private void taSelectedKeyReleased(KeyEvent evt) {//GEN-FIRST:event_taSelectedKeyReleased
        String[] vals = taSelected.getText().split("([\\s])+");
        StringBuilder sb = new StringBuilder();
        for (String v : vals) {
            sb.append(v.trim()).append(" ");
        }
        preferences.put(JavaNetRepositoryError.PROP_URLS, sb.toString());
    }//GEN-LAST:event_taSelectedKeyReleased


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private ButtonGroup buttonGroup1;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JRadioButton rbAny;
    private JRadioButton rbSelected;
    private JTextArea taSelected;
    // End of variables declaration//GEN-END:variables

}
