/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.io.nio.consumer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.nifi.io.nio.BufferPool;
import org.apache.nifi.io.nio.consumer.StreamConsumer;

public abstract class AbstractStreamConsumer
implements StreamConsumer {
    private final String uniqueId;
    private BufferPool bufferPool = null;
    private final BlockingQueue<ByteBuffer> filledBuffers = new LinkedBlockingQueue<ByteBuffer>();
    private final AtomicBoolean streamEnded = new AtomicBoolean(false);
    private final AtomicBoolean consumerEnded = new AtomicBoolean(false);

    public AbstractStreamConsumer(String id) {
        this.uniqueId = id;
    }

    @Override
    public final void setReturnBufferQueue(BufferPool returnQueue) {
        this.bufferPool = returnQueue;
    }

    @Override
    public final void addFilledBuffer(ByteBuffer buffer) {
        if (this.isConsumerFinished()) {
            buffer.clear();
            this.bufferPool.returnBuffer(buffer, buffer.remaining());
        } else {
            this.filledBuffers.add(buffer);
        }
    }

    @Override
    public final void process() throws IOException {
        if (this.isConsumerFinished()) {
            return;
        }
        if (this.streamEnded.get() && this.filledBuffers.isEmpty()) {
            this.consumerEnded.set(true);
            this.onConsumerDone();
            return;
        }
        ByteBuffer buffer = (ByteBuffer)this.filledBuffers.poll();
        if (buffer != null) {
            int bytesToProcess = buffer.remaining();
            try {
                this.processBuffer(buffer);
            }
            finally {
                buffer.clear();
                this.bufferPool.returnBuffer(buffer, bytesToProcess);
            }
        }
    }

    protected abstract void processBuffer(ByteBuffer var1) throws IOException;

    @Override
    public final void signalEndOfStream() {
        this.streamEnded.set(true);
    }

    protected void onConsumerDone() {
    }

    @Override
    public final boolean isConsumerFinished() {
        return this.consumerEnded.get();
    }

    @Override
    public final String getId() {
        return this.uniqueId;
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractStreamConsumer rhs = (AbstractStreamConsumer)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.uniqueId, (Object)rhs.uniqueId).isEquals();
    }

    public final int hashCode() {
        return new HashCodeBuilder(19, 23).append((Object)this.uniqueId).toHashCode();
    }

    public final String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.NO_FIELD_NAMES_STYLE).append((Object)this.uniqueId).toString();
    }
}

