/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.metrics.PerformanceTracker;
import org.apache.nifi.controller.repository.metrics.PerformanceTrackingInputStream;
import org.apache.nifi.stream.io.StreamUtils;

public class ContentClaimInputStream
extends InputStream {
    private final ContentRepository contentRepository;
    private final ContentClaim contentClaim;
    private final long claimOffset;
    private final PerformanceTracker performanceTracker;
    private InputStream delegate;
    private long bytesConsumed;
    private long currentOffset;
    private long markOffset;
    private InputStream bufferedIn;
    private int markReadLimit;

    public ContentClaimInputStream(ContentRepository contentRepository, ContentClaim contentClaim, long claimOffset, PerformanceTracker performanceTracker) {
        this(contentRepository, contentClaim, claimOffset, null, performanceTracker);
    }

    public ContentClaimInputStream(ContentRepository contentRepository, ContentClaim contentClaim, long claimOffset, InputStream initialDelegate, PerformanceTracker performanceTracker) {
        this.contentRepository = contentRepository;
        this.contentClaim = contentClaim;
        this.claimOffset = claimOffset;
        this.performanceTracker = performanceTracker;
        this.currentOffset = claimOffset;
        this.delegate = initialDelegate;
        if (this.delegate != null) {
            this.bufferedIn = new BufferedInputStream(this.delegate);
        }
    }

    private InputStream getDelegate() throws IOException {
        this.bufferedIn = null;
        if (this.delegate == null) {
            this.formDelegate();
        }
        return this.delegate;
    }

    public long getBytesConsumed() {
        return this.bytesConsumed;
    }

    public long getCurrentOffset() {
        return this.currentOffset;
    }

    @Override
    public int read() throws IOException {
        int value = this.bufferedIn == null ? this.getDelegate().read() : this.bufferedIn.read();
        if (value != -1) {
            ++this.bytesConsumed;
            ++this.currentOffset;
        }
        return value;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int count = this.bufferedIn == null ? this.getDelegate().read(b) : this.bufferedIn.read(b);
        if (count != -1) {
            this.bytesConsumed += (long)count;
            this.currentOffset += (long)count;
        }
        return count;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int count = this.bufferedIn == null ? this.getDelegate().read(b, off, len) : this.bufferedIn.read(b, off, len);
        if (count != -1) {
            this.bytesConsumed += (long)count;
            this.currentOffset += (long)count;
        }
        return count;
    }

    @Override
    public long skip(long n) throws IOException {
        long count = 0L;
        if (this.bufferedIn != null) {
            count = this.bufferedIn.skip(n);
        }
        if (count <= 0L) {
            count = this.getDelegate().skip(n);
        }
        if (count > 0L) {
            this.bytesConsumed += count;
            this.currentOffset += count;
        }
        return count;
    }

    @Override
    public int available() throws IOException {
        if (this.delegate == null) {
            return 0;
        }
        return this.delegate.available();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readLimit) {
        this.markOffset = this.currentOffset;
        this.markReadLimit = readLimit;
        if (this.bufferedIn == null) {
            try {
                this.bufferedIn = new BufferedInputStream(this.getDelegate());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read repository Content Claim", e);
            }
        }
        this.bufferedIn.mark(readLimit);
    }

    @Override
    public void reset() throws IOException {
        if (this.markOffset < 0L) {
            throw new IOException("Stream has not been marked");
        }
        if (this.bufferedIn != null) {
            if (this.currentOffset - this.markOffset <= (long)this.markReadLimit) {
                this.bufferedIn.reset();
                this.currentOffset = this.markOffset;
                return;
            }
            this.bufferedIn = null;
        }
        if (this.currentOffset != this.markOffset) {
            if (this.delegate != null) {
                this.delegate.close();
            }
            this.formDelegate();
            this.performanceTracker.beginContentRead();
            try {
                StreamUtils.skip((InputStream)this.delegate, (long)(this.markOffset - this.claimOffset));
            }
            finally {
                this.performanceTracker.endContentRead();
            }
            this.currentOffset = this.markOffset;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.bufferedIn != null) {
            this.bufferedIn.close();
        }
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    private void formDelegate() throws IOException {
        if (this.delegate != null) {
            this.delegate.close();
        }
        this.performanceTracker.beginContentRead();
        try {
            this.delegate = new PerformanceTrackingInputStream(this.contentRepository.read(this.contentClaim), this.performanceTracker);
            StreamUtils.skip((InputStream)this.delegate, (long)this.claimOffset);
            this.currentOffset = this.claimOffset;
        }
        finally {
            this.performanceTracker.endContentRead();
        }
    }
}

