/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.ScalarFunction;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class CotDoubleFunctionFactory
implements FunctionFactory {
    public static final String SYMBOL = "cot";

    @Override
    public String getSignature() {
        return "cot(D)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CotFunction(args.getQuick(0));
    }

    private static class CotFunction
    extends DoubleFunction
    implements ScalarFunction,
    UnaryFunction {
        final Function angleRad;

        public CotFunction(Function angleRad) {
            this.angleRad = angleRad;
        }

        @Override
        public Function getArg() {
            return this.angleRad;
        }

        @Override
        public double getDouble(Record rec) {
            double angle = this.angleRad.getDouble(rec);
            if (Double.isNaN(angle) || Double.isInfinite(angle)) {
                return Double.NaN;
            }
            return 1.0 / Math.tan(angle);
        }

        @Override
        public String getName() {
            return CotDoubleFunctionFactory.SYMBOL;
        }
    }
}

