/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.util;

import jetbrains.exodus.util.SpinAllocator;

public class StringBuilderSpinAllocator {
    private static final SpinAllocator<StringBuilder> allocator = new SpinAllocator<StringBuilder>(new Creator(), new Disposer(), 100);

    private StringBuilderSpinAllocator() {
    }

    public static StringBuilder alloc() {
        return allocator.alloc();
    }

    public static void dispose(StringBuilder instance) {
        allocator.dispose(instance);
    }

    private static class Disposer
    implements SpinAllocator.IDisposer<StringBuilder> {
        private Disposer() {
        }

        @Override
        public void disposeInstance(StringBuilder instance) {
            instance.setLength(0);
            if (instance.capacity() > 4096) {
                instance.trimToSize();
            }
        }
    }

    private static class Creator
    implements SpinAllocator.ICreator<StringBuilder> {
        private Creator() {
        }

        @Override
        public StringBuilder createInstance() {
            return new StringBuilder();
        }
    }
}

