/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties.configuration;

import com.azure.security.keyvault.keys.cryptography.CryptographyClient;
import com.azure.security.keyvault.keys.cryptography.CryptographyClientBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.nifi.properties.SensitivePropertyProtectionException;
import org.apache.nifi.properties.configuration.AzureClientProvider;

public class AzureCryptographyClientProvider
extends AzureClientProvider<CryptographyClient> {
    protected static final String KEY_ID_PROPERTY = "azure.keyvault.key.id";
    private static final Set<String> REQUIRED_PROPERTY_NAMES = new HashSet<String>(Collections.singletonList("azure.keyvault.key.id"));

    protected CryptographyClient getConfiguredClient(Properties clientProperties) {
        String keyIdentifier = clientProperties.getProperty(KEY_ID_PROPERTY);
        this.logger.debug("Azure Cryptography Client with Key Identifier [{}]", (Object)keyIdentifier);
        try {
            return new CryptographyClientBuilder().credential(this.getDefaultTokenCredential()).keyIdentifier(keyIdentifier).buildClient();
        }
        catch (RuntimeException e) {
            throw new SensitivePropertyProtectionException("Azure Cryptography Builder Client Failed using Default Credentials", (Throwable)e);
        }
    }

    protected Set<String> getRequiredPropertyNames() {
        return REQUIRED_PROPERTY_NAMES;
    }
}

