/*
 * Decompiled with CFR 0.152.
 */
package v14.h2.command.ddl;

import java.util.ArrayList;
import v14.h2.command.ddl.DefineCommand;
import v14.h2.engine.Database;
import v14.h2.engine.Session;
import v14.h2.message.DbException;
import v14.h2.schema.Schema;
import v14.h2.schema.SchemaObject;

public class AlterSchemaRename
extends DefineCommand {
    private Schema oldSchema;
    private String newSchemaName;

    public AlterSchemaRename(Session session) {
        super(session);
    }

    public void setOldSchema(Schema schema) {
        this.oldSchema = schema;
    }

    public void setNewName(String string) {
        this.newSchemaName = string;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        if (!this.oldSchema.canDrop()) {
            throw DbException.get(90090, this.oldSchema.getName());
        }
        if (database.findSchema(this.newSchemaName) != null || this.newSchemaName.equals(this.oldSchema.getName())) {
            throw DbException.get(90078, this.newSchemaName);
        }
        this.session.getUser().checkSchemaAdmin();
        database.renameDatabaseObject(this.session, this.oldSchema, this.newSchemaName);
        ArrayList<SchemaObject> arrayList = database.getAllSchemaObjects();
        for (SchemaObject schemaObject : arrayList) {
            database.updateMeta(this.session, schemaObject);
        }
        return 0;
    }

    @Override
    public int getType() {
        return 2;
    }
}

