/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.bundle.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.extension.manifest.Extension;
import org.apache.nifi.registry.bundle.model.BundleIdentifier;
import org.apache.nifi.registry.bundle.util.BundleUtils;
import org.apache.nifi.registry.extension.bundle.BuildInfo;

public class BundleDetails {
    private final BundleIdentifier bundleIdentifier;
    private final Set<BundleIdentifier> dependencies;
    private final String systemApiVersion;
    private final Set<Extension> extensions;
    private final Map<String, String> additionalDetails;
    private final BuildInfo buildInfo;

    private BundleDetails(Builder builder) {
        this.bundleIdentifier = builder.bundleIdentifier;
        this.dependencies = Collections.unmodifiableSet(new HashSet(builder.dependencies));
        this.extensions = Collections.unmodifiableSet(new HashSet(builder.extensions));
        this.additionalDetails = Collections.unmodifiableMap(new HashMap(builder.additionalDetails));
        this.systemApiVersion = builder.systemApiVersion;
        this.buildInfo = builder.buildInfo;
        BundleUtils.validateNotNull("Bundle Coordinate", this.bundleIdentifier);
        BundleUtils.validateNotNull("Dependency Coordinates", this.dependencies);
        BundleUtils.validateNotNull("Extension Details", this.extensions);
        BundleUtils.validateNotNull("System API Version", this.systemApiVersion);
        BundleUtils.validateNotNull("Build Details", this.buildInfo);
    }

    public BundleIdentifier getBundleIdentifier() {
        return this.bundleIdentifier;
    }

    public Set<BundleIdentifier> getDependencies() {
        return this.dependencies;
    }

    public String getSystemApiVersion() {
        return this.systemApiVersion;
    }

    public Set<Extension> getExtensions() {
        return this.extensions;
    }

    public Map<String, String> getAdditionalDetails() {
        return this.additionalDetails;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public static class Builder {
        private BundleIdentifier bundleIdentifier;
        private Set<BundleIdentifier> dependencies = new HashSet<BundleIdentifier>();
        private Set<Extension> extensions = new HashSet<Extension>();
        private Map<String, String> additionalDetails = new HashMap<String, String>();
        private BuildInfo buildInfo;
        private String systemApiVersion;

        public Builder coordinate(BundleIdentifier bundleIdentifier) {
            this.bundleIdentifier = bundleIdentifier;
            return this;
        }

        public Builder addDependencyCoordinate(BundleIdentifier dependencyCoordinate) {
            if (dependencyCoordinate != null) {
                this.dependencies.add(dependencyCoordinate);
            }
            return this;
        }

        public Builder systemApiVersion(String systemApiVersion) {
            this.systemApiVersion = systemApiVersion;
            return this;
        }

        public Builder addExtension(Extension extension) {
            if (extension != null) {
                this.extensions.add(extension);
            }
            return this;
        }

        public Builder addExtensions(List<Extension> extensions) {
            if (extensions != null) {
                this.extensions.addAll(extensions);
            }
            return this;
        }

        public Builder addAdditionalDetails(String extensionName, String additionalDetails) {
            this.additionalDetails.put(extensionName, additionalDetails);
            return this;
        }

        public Builder buildInfo(BuildInfo buildInfo) {
            this.buildInfo = buildInfo;
            return this;
        }

        public BundleDetails build() {
            return new BundleDetails(this);
        }
    }
}

