/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.writer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.toolkit.cli.impl.result.writer.TableColumn;

public class Table {
    public static String EMPTY_VALUE = "(empty)";
    private final List<TableColumn> columns;
    private final List<String[]> rows = new ArrayList<String[]>();

    private Table(Builder builder) {
        this.columns = Collections.unmodifiableList(builder.columns == null ? Collections.emptyList() : new ArrayList(builder.columns));
        if (this.columns.isEmpty()) {
            throw new IllegalStateException("Cannot create a table with no columns");
        }
    }

    public void addRow(String ... values) {
        if (values == null) {
            throw new IllegalArgumentException("Values cannot be null");
        }
        if (values.length != this.columns.size()) {
            throw new IllegalArgumentException("Row has " + values.length + " columns, but table has " + this.columns.size() + " columns");
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            values[i] = EMPTY_VALUE;
        }
        this.rows.add(values);
    }

    public List<TableColumn> getColumns() {
        return this.columns;
    }

    public List<String[]> getRows() {
        return this.rows;
    }

    public static class Builder {
        private final List<TableColumn> columns = new ArrayList<TableColumn>();

        public Builder column(TableColumn column) {
            if (column == null) {
                throw new IllegalArgumentException("TableColumn cannot be null");
            }
            this.columns.add(column);
            return this;
        }

        public Builder column(String name, int minLength, int maxLength, boolean abbreviate) {
            TableColumn column = new TableColumn(name, minLength, maxLength, abbreviate);
            return this.column(column);
        }

        public Table build() {
            return new Table(this);
        }
    }
}

