/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.selection;

import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.selection.MultiAttributeEvaluator;

public class DelineatedAttributeEvaluator
extends MultiAttributeEvaluator {
    private final Evaluator<String> subjectEvaluator;
    private final Evaluator<String> delimiterEvaluator;
    private final int evaluationType;

    public DelineatedAttributeEvaluator(Evaluator<String> subjectEvaluator, Evaluator<String> delimiterEvaluator, int evaluationType) {
        this.subjectEvaluator = subjectEvaluator;
        this.delimiterEvaluator = delimiterEvaluator;
        this.evaluationType = evaluationType;
    }

    @Override
    public QueryResult<String> evaluate(EvaluationContext evaluationContext) {
        State state = evaluationContext.getEvaluatorState().getState(this, State.class);
        if (state == null) {
            state = new State();
            evaluationContext.getEvaluatorState().putState(this, state);
        }
        if (state.delineatedValues == null) {
            QueryResult<String> subjectValue = this.subjectEvaluator.evaluate(evaluationContext);
            if (subjectValue.getValue() == null) {
                state.evaluationsLeft = 0;
                return new StringQueryResult(null);
            }
            QueryResult<String> delimiterValue = this.delimiterEvaluator.evaluate(evaluationContext);
            if (delimiterValue.getValue() == null) {
                state.evaluationsLeft = 0;
                return new StringQueryResult(null);
            }
            State.access$102(state, subjectValue.getValue().split(delimiterValue.getValue()));
        }
        if (state.evaluationCount > state.delineatedValues.length || state.delineatedValues.length == 0) {
            state.evaluationsLeft = 0;
            return new StringQueryResult(null);
        }
        state.evaluationsLeft = state.delineatedValues.length - state.evaluationCount - 1;
        return new StringQueryResult(state.delineatedValues[state.evaluationCount++]);
    }

    @Override
    public Evaluator<?> getLogicEvaluator() {
        return this.subjectEvaluator;
    }

    @Override
    public int getEvaluationsRemaining(EvaluationContext evaluationContext) {
        State state = evaluationContext.getEvaluatorState().getState(this, State.class);
        if (state == null) {
            state = new State();
            evaluationContext.getEvaluatorState().putState(this, state);
        }
        return state.evaluationsLeft;
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return null;
    }

    @Override
    public int getEvaluationType() {
        return this.evaluationType;
    }

    private static class State {
        private String[] delineatedValues;
        private int evaluationCount = 0;
        private int evaluationsLeft = 1;

        private State() {
        }

        static /* synthetic */ String[] access$102(State x0, String[] x1) {
            x0.delineatedValues = x1;
            return x1;
        }
    }
}

