/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.file.monitor;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import org.apache.nifi.util.file.monitor.UpdateMonitor;
import org.apache.nifi.util.security.MessageDigestUtils;

public class DigestUpdateMonitor
implements UpdateMonitor {
    @Override
    public Object getCurrentState(Path path) throws IOException {
        try (FileInputStream fis = new FileInputStream(path.toFile());){
            byte[] digest = MessageDigestUtils.getDigest(fis);
            ByteBuffer byteBuffer = ByteBuffer.wrap(digest);
            return byteBuffer;
        }
    }
}

