/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.cairo.ColumnIndexer;
import io.questdb.cairo.TableWriter;
import io.questdb.mp.AbstractQueueConsumerJob;
import io.questdb.mp.SOCountDownLatch;
import io.questdb.tasks.ColumnIndexerTask;

public class ColumnIndexerJob
extends AbstractQueueConsumerJob<ColumnIndexerTask> {
    public ColumnIndexerJob(MessageBus messageBus) {
        super(messageBus.getIndexerQueue(), messageBus.getIndexerSubSequence());
    }

    @Override
    protected boolean doRun(int workerId, long cursor) {
        ColumnIndexerTask queueItem = (ColumnIndexerTask)this.queue.get(cursor);
        ColumnIndexer indexer = queueItem.indexer;
        long lo = queueItem.lo;
        long hi = queueItem.hi;
        long indexSequence = queueItem.sequence;
        SOCountDownLatch latch = queueItem.countDownLatch;
        this.subSeq.done(cursor);
        if (indexer.tryLock(indexSequence)) {
            TableWriter.indexAndCountDown(indexer, lo, hi, latch);
            return true;
        }
        return false;
    }
}

