/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AbstractRecordMetadata;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.std.Chars;

class TableWriterMetadata
extends AbstractRecordMetadata
implements TableRecordMetadata {
    private int maxUncommittedRows;
    private long o3MaxLag;
    private long structureVersion;
    private int symbolMapCount;
    private int tableId;
    private TableToken tableToken;
    private int version;
    private boolean walEnabled;

    public TableWriterMetadata(TableToken tableToken, MemoryMR metaMem) {
        this.tableToken = tableToken;
        this.reload(metaMem);
    }

    @Override
    public void close() {
    }

    @Override
    public int getMaxUncommittedRows() {
        return this.maxUncommittedRows;
    }

    @Override
    public long getO3MaxLag() {
        return this.o3MaxLag;
    }

    @Override
    public long getStructureVersion() {
        return this.structureVersion;
    }

    public int getSymbolMapCount() {
        return this.symbolMapCount;
    }

    @Override
    public int getTableId() {
        return this.tableId;
    }

    @Override
    public TableToken getTableToken() {
        return this.tableToken;
    }

    public int getTableVersion() {
        return this.version;
    }

    @Override
    public boolean isWalEnabled() {
        return this.walEnabled;
    }

    public final void reload(MemoryMR metaMem) {
        this.columnCount = metaMem.getInt(0L);
        this.columnNameIndexMap.clear();
        this.version = metaMem.getInt(12L);
        this.tableId = metaMem.getInt(16L);
        this.maxUncommittedRows = metaMem.getInt(20L);
        this.o3MaxLag = metaMem.getLong(24L);
        TableUtils.validateMeta(metaMem, this.columnNameIndexMap, 426);
        this.timestampIndex = metaMem.getInt(8L);
        this.columnMetadata.clear();
        this.structureVersion = metaMem.getLong(32L);
        this.walEnabled = metaMem.getBool(40L);
        long offset = TableUtils.getColumnNameOffset(this.columnCount);
        this.symbolMapCount = 0;
        this.columnNameIndexMap.clear();
        for (int i = 0; i < this.columnCount; ++i) {
            CharSequence name = metaMem.getStr(offset);
            assert (name != null);
            int type = TableUtils.getColumnType(metaMem, i);
            String nameStr = Chars.toString(name);
            this.columnMetadata.add(new TableColumnMetadata(nameStr, type, TableUtils.isColumnIndexed(metaMem, i), TableUtils.getIndexBlockCapacity(metaMem, i), true, null, i));
            this.columnNameIndexMap.put(nameStr, i);
            if (ColumnType.isSymbol(type)) {
                ++this.symbolMapCount;
            }
            offset += (long)Vm.getStorageLength(name);
        }
    }

    public void setMaxUncommittedRows(int rows) {
        this.maxUncommittedRows = rows;
    }

    public void setO3MaxLag(long o3MaxLagUs) {
        this.o3MaxLag = o3MaxLagUs;
    }

    public void setStructureVersion(long value) {
        this.structureVersion = value;
    }

    public void setTableVersion() {
        this.version = 426;
    }

    public void updateTableToken(TableToken tableToken) {
        this.tableToken = tableToken;
    }

    void addColumn(CharSequence name, int type, boolean indexFlag, int indexValueBlockCapacity, int columnIndex) {
        String str = name.toString();
        this.columnNameIndexMap.put(str, this.columnMetadata.size());
        this.columnMetadata.add(new TableColumnMetadata(str, type, indexFlag, indexValueBlockCapacity, true, null, columnIndex));
        ++this.columnCount;
        if (ColumnType.isSymbol(type)) {
            ++this.symbolMapCount;
        }
    }

    void clearTimestampIndex() {
        this.timestampIndex = -1;
    }

    void removeColumn(int columnIndex) {
        TableColumnMetadata deletedMeta = (TableColumnMetadata)this.columnMetadata.getQuick(columnIndex);
        if (ColumnType.isSymbol(deletedMeta.getType())) {
            --this.symbolMapCount;
        }
        deletedMeta.markDeleted();
        this.columnNameIndexMap.remove(deletedMeta.getName());
    }

    void renameColumn(CharSequence name, CharSequence newName) {
        int columnIndex = this.columnNameIndexMap.removeEntry(name);
        String newNameStr = Chars.toString(newName);
        this.columnNameIndexMap.put(newNameStr, columnIndex);
        TableColumnMetadata oldColumnMetadata = (TableColumnMetadata)this.columnMetadata.get(columnIndex);
        oldColumnMetadata.setName(newNameStr);
    }
}

