/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.pool;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.pool.AbstractMultiTenantPool;
import io.questdb.cairo.pool.PoolTenant;

public class ReaderPool
extends AbstractMultiTenantPool<R> {
    private final MessageBus messageBus;

    public ReaderPool(CairoConfiguration configuration, MessageBus messageBus) {
        super(configuration);
        this.messageBus = messageBus;
    }

    @Override
    protected byte getListenerSrc() {
        return 2;
    }

    @Override
    protected R newTenant(TableToken tableName, AbstractMultiTenantPool.Entry<R> entry, int index) {
        return new R(this, entry, index, tableName, this.messageBus);
    }

    public static class R
    extends TableReader
    implements PoolTenant {
        private final int index;
        private AbstractMultiTenantPool.Entry<R> entry;
        private AbstractMultiTenantPool<R> pool;

        public R(AbstractMultiTenantPool<R> pool, AbstractMultiTenantPool.Entry<R> entry, int index, TableToken tableToken, MessageBus messageBus) {
            super(pool.getConfiguration(), tableToken, messageBus);
            this.pool = pool;
            this.entry = entry;
            this.index = index;
        }

        @Override
        public void close() {
            if (this.isOpen()) {
                this.goPassive();
                AbstractMultiTenantPool<R> pool = this.pool;
                if (pool != null && this.entry != null && pool.returnToPool(this)) {
                    return;
                }
                super.close();
            }
        }

        public AbstractMultiTenantPool.Entry<R> getEntry() {
            return this.entry;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public void goodbye() {
            this.entry = null;
            this.pool = null;
        }

        @Override
        public void refresh() {
            try {
                this.goActive();
            }
            catch (Throwable ex) {
                this.close();
                throw ex;
            }
        }
    }
}

