/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.FloatFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class CeilFloatFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "ceil(F)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CeilFunction(args.getQuick(0));
    }

    private static class CeilFunction
    extends FloatFunction
    implements UnaryFunction {
        private final Function function;

        public CeilFunction(Function function) {
            this.function = function;
        }

        @Override
        public Function getArg() {
            return this.function;
        }

        @Override
        public float getFloat(Record rec) {
            float value = this.function.getFloat(rec);
            return (float)Math.ceil(value);
        }

        @Override
        public String getName() {
            return "ceil";
        }
    }
}

