/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.tls.manager.writer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.nifi.toolkit.tls.manager.writer.ConfigurationWriter;
import org.apache.nifi.toolkit.tls.util.OutputStreamFactory;

public class JsonConfigurationWriter<T>
implements ConfigurationWriter<T> {
    private final ObjectWriter objectWriter;
    private final File file;

    public JsonConfigurationWriter(ObjectMapper objectMapper, File file) {
        this.objectWriter = objectMapper.writerWithDefaultPrettyPrinter();
        this.file = file;
    }

    @Override
    public void write(T tlsConfig, OutputStreamFactory outputStreamFactory) throws IOException {
        try (OutputStream stream = outputStreamFactory.create(this.file);){
            this.objectWriter.writeValue(stream, tlsConfig);
        }
    }
}

