/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.CachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.ConstantEntityIterableHandle;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.FieldIndexIterator;
import jetbrains.exodus.entitystore.iterate.PropertyChangedHandleChecker;
import jetbrains.exodus.entitystore.iterate.UpdatableEntityIdSortedSetCachedInstanceIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntitiesWithPropertyIterable
extends EntityIterableBase {
    private final int entityTypeId;
    private final int propertyId;

    public EntitiesWithPropertyIterable(@NotNull PersistentStoreTransaction txn, int entityTypeId, int propertyId) {
        super(txn);
        this.entityTypeId = entityTypeId;
        this.propertyId = propertyId;
    }

    public static EntityIterableType getType() {
        return EntityIterableType.ENTITIES_WITH_PROPERTY;
    }

    @Override
    public int getEntityTypeId() {
        return this.entityTypeId;
    }

    @Override
    @NotNull
    public EntityIterator getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new FieldIndexIterator(this, this.entityTypeId, this.propertyId, this.getStore().getEntityWithPropIterable(txn, this.entityTypeId, this.propertyId));
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new EntitiesWithPropertyIterableHandle();
    }

    @Override
    protected CachedInstanceIterable createCachedInstance(@NotNull PersistentStoreTransaction txn) {
        return new UpdatableEntityIdSortedSetCachedInstanceIterable(txn, this);
    }

    static {
        EntitiesWithPropertyIterable.registerType(EntitiesWithPropertyIterable.getType(), (txn, store, parameters) -> new EntitiesWithPropertyIterable(txn, Integer.parseInt((String)parameters[0]), Integer.parseInt((String)parameters[1])));
    }

    private final class EntitiesWithPropertyIterableHandle
    extends ConstantEntityIterableHandle {
        private EntitiesWithPropertyIterableHandle() {
            super(EntitiesWithPropertyIterable.this.getStore(), EntitiesWithPropertyIterable.getType());
        }

        @Override
        @NotNull
        public int[] getPropertyIds() {
            return new int[]{EntitiesWithPropertyIterable.this.propertyId};
        }

        @Override
        public void toString(@NotNull StringBuilder builder) {
            super.toString(builder);
            builder.append(EntitiesWithPropertyIterable.this.entityTypeId);
            builder.append('-');
            builder.append(EntitiesWithPropertyIterable.this.propertyId);
        }

        @Override
        public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
            hash.apply(EntitiesWithPropertyIterable.this.entityTypeId);
            hash.applyDelimiter();
            hash.apply(EntitiesWithPropertyIterable.this.propertyId);
        }

        @Override
        public int getEntityTypeId() {
            return EntitiesWithPropertyIterable.this.entityTypeId;
        }

        @Override
        public boolean isMatchedPropertyChanged(@NotNull EntityId id, int propertyId, @Nullable Comparable oldValue, @Nullable Comparable newValue) {
            return EntitiesWithPropertyIterable.this.propertyId == propertyId && EntitiesWithPropertyIterable.this.entityTypeId == id.getTypeId();
        }

        @Override
        public boolean onPropertyChanged(@NotNull PropertyChangedHandleChecker handleChecker) {
            UpdatableEntityIdSortedSetCachedInstanceIterable iterable2;
            Comparable oldValue = handleChecker.getOldValue();
            Comparable newValue = handleChecker.getNewValue();
            if ((oldValue == null || newValue == null) && (iterable2 = PersistentStoreTransaction.getUpdatable(handleChecker, this, UpdatableEntityIdSortedSetCachedInstanceIterable.class)) != null) {
                long localId = handleChecker.getLocalId();
                if (oldValue == null) {
                    iterable2.addEntity(new PersistentEntityId(EntitiesWithPropertyIterable.this.entityTypeId, localId));
                } else {
                    iterable2.removeEntity(new PersistentEntityId(EntitiesWithPropertyIterable.this.entityTypeId, localId));
                }
                return true;
            }
            return false;
        }
    }
}

