/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate.cached.iterator;

import java.util.Iterator;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.NonDisposableEntityIterator;
import jetbrains.exodus.entitystore.iterate.OrderedEntityIdCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReverseOrderedEntityIdCollectionIterator
extends NonDisposableEntityIterator {
    private int index = 0;
    @NotNull
    private final OrderedEntityIdCollection source;
    @NotNull
    private final Iterator<EntityId> sourceIterator;

    public ReverseOrderedEntityIdCollectionIterator(@NotNull EntityIterableBase iterable2, @NotNull OrderedEntityIdCollection source) {
        super(iterable2);
        this.source = source;
        this.sourceIterator = source.reverseIterator();
    }

    @Override
    public boolean skip(int number) {
        while (number-- > 0 && this.sourceIterator.hasNext()) {
            this.nextIdImpl();
        }
        return this.sourceIterator.hasNext();
    }

    @Override
    @Nullable
    public EntityId nextId() {
        EntityId result = this.sourceIterator.next();
        ++this.index;
        return result;
    }

    @Override
    @Nullable
    public EntityId getLast() {
        return this.source.getFirst();
    }

    @Override
    @Nullable
    public EntityId nextIdImpl() {
        EntityId result = this.sourceIterator.next();
        ++this.index;
        return result;
    }

    @Override
    protected boolean hasNextImpl() {
        return this.sourceIterator.hasNext();
    }

    @Override
    protected int getIndex() {
        return this.index;
    }
}

