/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.vault.hashicorp.config;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.vault.hashicorp.config.HashiCorpVaultProperties;
import org.apache.nifi.vault.hashicorp.config.lookup.BeanPropertyLookup;
import org.apache.nifi.vault.hashicorp.config.lookup.PropertyLookup;
import org.springframework.core.env.PropertySource;

public class HashiCorpVaultPropertySource
extends PropertySource<HashiCorpVaultProperties> {
    private static final String PREFIX = "vault";
    private static final Pattern DASH_LETTER_PATTERN = Pattern.compile("-[a-z]");
    private PropertyLookup propertyLookup = new BeanPropertyLookup("vault", HashiCorpVaultProperties.class);

    public HashiCorpVaultPropertySource(HashiCorpVaultProperties source) {
        super(HashiCorpVaultPropertySource.class.getName(), (Object)source);
    }

    public Object getProperty(String key) {
        Objects.requireNonNull(key, "Property key cannot be null");
        return this.propertyLookup.getPropertyValue(this.getPropertyKey(key), this.getSource());
    }

    private String getPropertyKey(String springPropertyKey) {
        Matcher m = DASH_LETTER_PATTERN.matcher(springPropertyKey);
        StringBuffer result = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(result, m.group(0).substring(1).toUpperCase());
        }
        m.appendTail(result);
        return result.toString();
    }
}

