/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.s2s;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.nifi.remote.protocol.DataPacket;
import org.apache.nifi.toolkit.s2s.DataPacketImpl;

public class DataPacketDto {
    public static final TypeReference<DataPacketDto> DATA_PACKET_DTO_TYPE_REFERENCE = new TypeReference<DataPacketDto>(){};
    private Map<String, String> attributes;
    private byte[] data;
    private String dataFile;

    public DataPacketDto() {
        this(null);
    }

    public DataPacketDto(byte[] data) {
        this(new HashMap<String, String>(), data);
    }

    public DataPacketDto(Map<String, String> attributes, byte[] data) {
        this(attributes, data, null);
    }

    public DataPacketDto(Map<String, String> attributes, String dataFile) {
        this(attributes, null, dataFile);
    }

    public DataPacketDto(Map<String, String> attributes, byte[] data, String dataFile) {
        this.attributes = attributes;
        this.data = data;
        this.dataFile = dataFile;
    }

    public static Stream<DataPacket> getDataPacketStream(InputStream inputStream) throws IOException {
        final JsonParser jsonParser = new JsonFactory().createParser(inputStream);
        if (jsonParser.nextToken() != JsonToken.START_ARRAY) {
            throw new IOException("Expecting start array token to begin object array.");
        }
        jsonParser.setCodec((ObjectCodec)new ObjectMapper());
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<DataPacket>(){
            DataPacket next = this.getNext();

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public DataPacket next() {
                DataPacket next = this.next;
                this.next = this.getNext();
                return next;
            }

            DataPacket getNext() throws RuntimeException {
                try {
                    if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
                        return null;
                    }
                    DataPacketDto dataPacketDto = (DataPacketDto)jsonParser.readValueAs(DATA_PACKET_DTO_TYPE_REFERENCE);
                    return dataPacketDto.toDataPacket();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }, 16), false);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public String getDataFile() {
        return this.dataFile;
    }

    public void setDataFile(String dataFile) {
        this.dataFile = dataFile;
    }

    public DataPacket toDataPacket() {
        return new DataPacketImpl(this.attributes, this.data, this.dataFile);
    }

    public DataPacketDto putAttribute(String key, String value) {
        this.attributes.put(key, value);
        return this;
    }
}

