/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.cookie;

import org.apache.nifi.web.security.cookie.SameSitePolicy;
import org.apache.nifi.web.security.http.SecurityCookieName;

public enum ApplicationCookieName {
    AUTHORIZATION_BEARER(SecurityCookieName.AUTHORIZATION_BEARER.getName(), SameSitePolicy.STRICT),
    REQUEST_TOKEN(SecurityCookieName.REQUEST_TOKEN.getName(), SameSitePolicy.STRICT),
    LOGOUT_REQUEST_IDENTIFIER("__Secure-Logout-Request-Identifier", SameSitePolicy.NONE),
    OIDC_REQUEST_IDENTIFIER("__Secure-OIDC-Request-Identifier", SameSitePolicy.NONE),
    SAML_REQUEST_IDENTIFIER("__Secure-SAML-Request-Identifier", SameSitePolicy.NONE);

    private final String cookieName;
    private final SameSitePolicy sameSitePolicy;

    private ApplicationCookieName(String cookieName, SameSitePolicy sameSitePolicy) {
        this.cookieName = cookieName;
        this.sameSitePolicy = sameSitePolicy;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public SameSitePolicy getSameSitePolicy() {
        return this.sameSitePolicy;
    }
}

