/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.revocation;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.web.security.jwt.revocation.JwtRevocationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardJwtRevocationService
implements JwtRevocationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardJwtRevocationService.class);
    private static final Scope SCOPE = Scope.LOCAL;
    private final StateManager stateManager;

    public StandardJwtRevocationService(StateManager stateManager) {
        this.stateManager = stateManager;
    }

    @Override
    public synchronized void deleteExpired() {
        Map state = this.getStateMap().toMap();
        Instant now = Instant.now();
        Map<String, String> updatedState = state.entrySet().stream().filter(entry -> Instant.parse((CharSequence)entry.getValue()).isAfter(now)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (updatedState.equals(state)) {
            LOGGER.debug("Expired Revocations not found");
        } else {
            try {
                this.stateManager.setState(updatedState, SCOPE);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Delete Expired Revocations Failed", e);
            }
            LOGGER.debug("Delete Expired Revocations: Before [{}] After [{}]", (Object)state.size(), (Object)updatedState.size());
        }
    }

    @Override
    public boolean isRevoked(String id) {
        StateMap stateMap = this.getStateMap();
        return stateMap.toMap().containsKey(id);
    }

    @Override
    public synchronized void setRevoked(String id, Instant expiration) {
        StateMap stateMap = this.getStateMap();
        HashMap<String, String> state = new HashMap<String, String>(stateMap.toMap());
        state.put(id, expiration.toString());
        try {
            this.stateManager.setState(state, SCOPE);
            LOGGER.debug("JWT Identifier [{}] Revocation Completed", (Object)id);
        }
        catch (IOException e) {
            LOGGER.error("JWT Identifier [{}] Revocation Failed", (Object)id, (Object)e);
        }
    }

    private StateMap getStateMap() {
        try {
            return this.stateManager.getState(SCOPE);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Get State Failed", e);
        }
    }
}

