/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.literals.StringLiteralEvaluator;
import org.apache.nifi.attribute.expression.language.exception.AttributeExpressionLanguageException;

public abstract class JsonPathBaseEvaluator
extends StringEvaluator {
    protected static final StringQueryResult EMPTY_RESULT = new StringQueryResult("");
    protected static final Configuration STRICT_PROVIDER_CONFIGURATION = Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonProvider()).build();
    protected static final JsonProvider JSON_PROVIDER = STRICT_PROVIDER_CONFIGURATION.jsonProvider();
    protected final Evaluator<String> subject;
    protected final Evaluator<String> jsonPathExp;
    protected final JsonPath precompiledJsonPathExp;

    public JsonPathBaseEvaluator(Evaluator<String> subject, Evaluator<String> jsonPathExp) {
        this.subject = subject;
        this.jsonPathExp = jsonPathExp;
        this.precompiledJsonPathExp = jsonPathExp instanceof StringLiteralEvaluator ? JsonPathBaseEvaluator.compileJsonPathExpression(jsonPathExp.evaluate(null).getValue()) : null;
    }

    protected DocumentContext getDocumentContext(EvaluationContext context) {
        String subjectValue = this.subject.evaluate(context).getValue();
        if (subjectValue == null || subjectValue.length() == 0) {
            throw new AttributeExpressionLanguageException("Subject is empty");
        }
        DocumentContext documentContext = null;
        try {
            documentContext = JsonPathBaseEvaluator.validateAndEstablishJsonContext(subjectValue);
        }
        catch (InvalidJsonException e) {
            throw new AttributeExpressionLanguageException("Subject contains invalid JSON: " + subjectValue, e);
        }
        return documentContext;
    }

    protected JsonPath getJsonPath(EvaluationContext context) {
        JsonPath compiledJsonPath = this.precompiledJsonPathExp != null ? this.precompiledJsonPathExp : JsonPathBaseEvaluator.compileJsonPathExpression(this.jsonPathExp.evaluate(context).getValue());
        return compiledJsonPath;
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }

    static DocumentContext validateAndEstablishJsonContext(String json) {
        DocumentContext ctx = JsonPath.using((Configuration)STRICT_PROVIDER_CONFIGURATION).parse(json);
        return ctx;
    }

    static boolean isJsonScalar(Object obj) {
        return !(obj instanceof Map) && !(obj instanceof List);
    }

    static String getResultRepresentation(Object jsonPathResult, String defaultValue) {
        if (JsonPathBaseEvaluator.isJsonScalar(jsonPathResult)) {
            return Objects.toString(jsonPathResult, defaultValue);
        }
        if (jsonPathResult instanceof List && ((List)jsonPathResult).size() == 1) {
            return JsonPathBaseEvaluator.getResultRepresentation(((List)jsonPathResult).get(0), defaultValue);
        }
        return JSON_PROVIDER.toJson(jsonPathResult);
    }

    static JsonPath compileJsonPathExpression(String exp) {
        try {
            return JsonPath.compile((String)exp, (Predicate[])new Predicate[0]);
        }
        catch (Exception e) {
            throw new AttributeExpressionLanguageException("Invalid JSON Path expression: " + exp, e);
        }
    }
}

