/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.toolkit.persistence;

import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.nifi.registry.NiFiRegistry;
import org.apache.nifi.registry.db.DataSourceFactory;
import org.apache.nifi.registry.db.DatabaseMetadataService;
import org.apache.nifi.registry.db.entity.BucketEntity;
import org.apache.nifi.registry.db.entity.FlowEntity;
import org.apache.nifi.registry.db.entity.FlowSnapshotEntity;
import org.apache.nifi.registry.extension.ExtensionManager;
import org.apache.nifi.registry.flow.FlowPersistenceProvider;
import org.apache.nifi.registry.flow.FlowSnapshotContext;
import org.apache.nifi.registry.properties.NiFiRegistryProperties;
import org.apache.nifi.registry.provider.StandardProviderFactory;
import org.apache.nifi.registry.provider.flow.StandardFlowSnapshotContext;
import org.apache.nifi.registry.service.MetadataService;
import org.apache.nifi.registry.service.mapper.BucketMappings;
import org.apache.nifi.registry.service.mapper.FlowMappings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class FlowPersistenceProviderMigrator {
    private static final Logger log = LoggerFactory.getLogger(FlowPersistenceProviderMigrator.class);
    public static final int PARSE_EXCEPTION = 1;

    public void doMigrate(MetadataService fromMetadata, FlowPersistenceProvider fromProvider, FlowPersistenceProvider toProvider) {
        for (BucketEntity bucket : fromMetadata.getAllBuckets()) {
            for (FlowEntity flow : fromMetadata.getFlowsByBucket(bucket.getId())) {
                for (FlowSnapshotEntity flowSnapshot : fromMetadata.getSnapshots(flow.getId())) {
                    StandardFlowSnapshotContext context = new StandardFlowSnapshotContext.Builder(BucketMappings.map((BucketEntity)bucket), FlowMappings.map((BucketEntity)bucket, (FlowEntity)flow), FlowMappings.map((BucketEntity)bucket, (FlowSnapshotEntity)flowSnapshot)).build();
                    int version = flowSnapshot.getVersion();
                    toProvider.saveFlowContent((FlowSnapshotContext)context, fromProvider.getFlowContent(bucket.getId(), flow.getId(), version));
                    log.info("Migrated flow {} version {}", (Object)flow.getName(), (Object)version);
                }
            }
        }
    }

    public static void main(String[] args) {
        Options options = new Options();
        options.addOption("t", "to", true, "Providers xml to migrate to.");
        DefaultParser parser = new DefaultParser();
        CommandLine commandLine = null;
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            log.error("Unable to parse command line.", (Throwable)e);
            new HelpFormatter().printHelp("persistence-toolkit [args]", options);
            System.exit(1);
        }
        NiFiRegistryProperties fromProperties = NiFiRegistry.initializeProperties();
        DataSource dataSource = new DataSourceFactory(fromProperties).getDataSource();
        DatabaseMetadataService fromMetadataService = new DatabaseMetadataService(new JdbcTemplate(dataSource));
        FlowPersistenceProvider fromPersistenceProvider = FlowPersistenceProviderMigrator.createFlowPersistenceProvider(fromProperties, dataSource);
        FlowPersistenceProvider toPersistenceProvider = FlowPersistenceProviderMigrator.createFlowPersistenceProvider(FlowPersistenceProviderMigrator.createToProperties(commandLine, fromProperties), dataSource);
        new FlowPersistenceProviderMigrator().doMigrate((MetadataService)fromMetadataService, fromPersistenceProvider, toPersistenceProvider);
    }

    private static NiFiRegistryProperties createToProperties(CommandLine commandLine, NiFiRegistryProperties fromProperties) {
        Properties props = new Properties();
        for (String propertyKey : fromProperties.getPropertyKeys()) {
            props.setProperty(propertyKey, fromProperties.getProperty(propertyKey));
        }
        props.setProperty("nifi.registry.providers.configuration.file", commandLine.getOptionValue('t'));
        NiFiRegistryProperties toProperties = new NiFiRegistryProperties(props);
        return toProperties;
    }

    private static FlowPersistenceProvider createFlowPersistenceProvider(NiFiRegistryProperties niFiRegistryProperties, DataSource dataSource) {
        ExtensionManager fromExtensionManager = new ExtensionManager(niFiRegistryProperties);
        fromExtensionManager.discoverExtensions();
        StandardProviderFactory fromProviderFactory = new StandardProviderFactory(niFiRegistryProperties, fromExtensionManager, dataSource);
        fromProviderFactory.initialize();
        return fromProviderFactory.getFlowPersistenceProvider();
    }
}

