/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.nar;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ControllerClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.NarUploadResult;
import org.apache.nifi.web.api.dto.NarSummaryDTO;
import org.apache.nifi.web.api.entity.NarSummaryEntity;

public class UploadNar
extends AbstractNiFiCommand<NarUploadResult> {
    private static final int MAX_TIMEOUT_SECONDS = 600;
    private static final int DEFAULT_TIMEOUT_SECONDS = 60;
    private static final long POLL_INTERVAL_MILLIS = 2000L;

    public UploadNar() {
        super("upload-nar", NarUploadResult.class);
    }

    @Override
    public String getDescription() {
        return "Uploads a NAR to the NAR Manager";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.NAR_FILE.createOption());
        this.addOption(CommandOption.NAR_UPLOAD_TIMEOUT.createOption());
    }

    @Override
    public NarUploadResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        ControllerClient controllerClient = client.getControllerClient();
        File narFile = new File(this.getRequiredArg(properties, CommandOption.NAR_FILE));
        NarSummaryEntity summaryEntity = this.uploadNar(controllerClient, narFile);
        String narId = summaryEntity.getNarSummary().getIdentifier();
        int timeoutSeconds = this.getProcessingTimeout(properties);
        int pollIterations = Math.max(Long.valueOf((long)timeoutSeconds * 1000L / 2000L).intValue(), 1);
        int maxPollIterations = Long.valueOf(300L).intValue();
        int selectedPollIterations = Math.min(pollIterations, maxPollIterations);
        NarSummaryEntity progressEntity = null;
        for (int i = 0; i < selectedPollIterations; ++i) {
            progressEntity = controllerClient.getNarSummary(narId);
            NarSummaryDTO progressDto = progressEntity.getNarSummary();
            if (progressDto.isInstallComplete()) {
                return new NarUploadResult(this.getResultType(properties), progressEntity);
            }
            try {
                if (this.getContext().isInteractive()) {
                    this.println("Waiting for NAR install to complete, current state is: " + progressDto.getState());
                }
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.println("NAR install has not completed within the given timeout, the install will continue to run and may complete later");
        return new NarUploadResult(this.getResultType(properties), progressEntity);
    }

    private NarSummaryEntity uploadNar(ControllerClient controllerClient, File narFile) throws NiFiClientException, IOException {
        try (FileInputStream inputStream = new FileInputStream(narFile);){
            NarSummaryEntity narSummaryEntity = controllerClient.uploadNar(narFile.getName(), inputStream);
            return narSummaryEntity;
        }
    }

    protected int getProcessingTimeout(Properties properties) {
        try {
            Integer updateTimeoutSeconds = this.getIntArg(properties, CommandOption.UPDATE_TIMEOUT);
            return updateTimeoutSeconds == null ? 60 : updateTimeoutSeconds;
        }
        catch (MissingOptionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

