/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.persistence.EntityListeners;
import org.apache.olingo.odata2.api.edm.provider.EntityType;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPATombstoneEntityListener;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAEdmBuilder;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAEdmMappingModelAccess;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmBaseView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmEntityTypeView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmKeyView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmMapping;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmNavigationPropertyView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmSchemaView;
import org.apache.olingo.odata2.jpa.processor.core.access.model.JPAEdmNameBuilder;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmBaseViewImpl;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmProperty;

public class JPAEdmEntityType
extends JPAEdmBaseViewImpl
implements JPAEdmEntityTypeView {
    private JPAEdmSchemaView schemaView = null;
    private EntityType currentEdmEntityType = null;
    private javax.persistence.metamodel.EntityType<?> currentJPAEntityType = null;
    private EntityTypeList<EntityType> consistentEntityTypes = null;
    private HashMap<String, EntityType> consistentEntityTypeMap;

    public JPAEdmEntityType(JPAEdmSchemaView view) {
        super((JPAEdmBaseView)view);
        this.schemaView = view;
        this.consistentEntityTypeMap = new HashMap();
    }

    public JPAEdmBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = new JPAEdmEntityTypeBuilder();
        }
        return this.builder;
    }

    public EntityType getEdmEntityType() {
        return this.currentEdmEntityType;
    }

    public javax.persistence.metamodel.EntityType<?> getJPAEntityType() {
        return this.currentJPAEntityType;
    }

    public List<EntityType> getConsistentEdmEntityTypes() {
        return this.consistentEntityTypes;
    }

    public EntityType searchEdmEntityType(String jpaEntityTypeName) {
        return this.consistentEntityTypeMap.get(jpaEntityTypeName);
    }

    private class EntityTypeListIterator<E>
    implements ListIterator<EntityType> {
        private int size = 0;
        private int pos = 0;

        public EntityTypeListIterator(int listSize) {
            this.size = listSize;
        }

        @Override
        public void add(EntityType e) {
            JPAEdmEntityType.this.consistentEntityTypes.add(e);
            ++this.size;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.size;
        }

        @Override
        public boolean hasPrevious() {
            return this.pos > 0;
        }

        @Override
        public EntityType next() {
            if (this.pos < this.size) {
                JPAEdmEntityType.this.currentEdmEntityType = (EntityType)JPAEdmEntityType.this.consistentEntityTypes.get(this.pos++);
                return JPAEdmEntityType.this.currentEdmEntityType;
            }
            return null;
        }

        @Override
        public int nextIndex() {
            return this.pos;
        }

        @Override
        public EntityType previous() {
            if (this.pos > 0 && this.pos < this.size) {
                JPAEdmEntityType.this.currentEdmEntityType = (EntityType)JPAEdmEntityType.this.consistentEntityTypes.get(--this.pos);
                return JPAEdmEntityType.this.currentEdmEntityType;
            }
            return null;
        }

        @Override
        public int previousIndex() {
            if (this.pos > 0) {
                return this.pos - 1;
            }
            return 0;
        }

        @Override
        public void remove() {
            JPAEdmEntityType.this.consistentEntityTypes.remove(this.pos);
        }

        @Override
        public void set(EntityType e) {
            JPAEdmEntityType.this.consistentEntityTypes.set(this.pos, e);
        }
    }

    private class EntityTypeList<X>
    extends ArrayList<EntityType> {
        private static final long serialVersionUID = 719079109608251592L;

        private EntityTypeList() {
        }

        @Override
        public Iterator<EntityType> iterator() {
            return new EntityTypeListIterator(this.size());
        }
    }

    private class JPAEdmEntityTypeBuilder
    implements JPAEdmBuilder {
        private JPAEdmEntityTypeBuilder() {
        }

        public void build() throws ODataJPAModelException, ODataJPARuntimeException {
            Collection<Object> jpaEntityTypes = JPAEdmEntityType.this.metaModel.getEntities();
            if (jpaEntityTypes == null || jpaEntityTypes.isEmpty()) {
                return;
            }
            if (JPAEdmEntityType.this.consistentEntityTypes == null) {
                JPAEdmEntityType.this.consistentEntityTypes = new EntityTypeList();
            }
            jpaEntityTypes = this.sortJPAEntityTypes(jpaEntityTypes);
            for (javax.persistence.metamodel.EntityType entityType : jpaEntityTypes) {
                JPAEdmNavigationPropertyView navPropView;
                JPAEdmEntityType.this.currentEdmEntityType = new EntityType();
                JPAEdmEntityType.this.currentJPAEntityType = entityType;
                if (this.isExcluded(JPAEdmEntityType.this)) continue;
                JPAEdmNameBuilder.build(JPAEdmEntityType.this);
                JPAEdmMapping jpaEdmMapping = (JPAEdmMapping)JPAEdmEntityType.this.currentEdmEntityType.getMapping();
                EntityListeners entityListners = JPAEdmEntityType.this.currentJPAEntityType.getJavaType().getAnnotation(EntityListeners.class);
                if (entityListners != null) {
                    for (Class entityListner : entityListners.value()) {
                        if (!ODataJPATombstoneEntityListener.class.isAssignableFrom(entityListner)) continue;
                        jpaEdmMapping.setODataJPATombstoneEntityListener(entityListner);
                        break;
                    }
                }
                JPAEdmProperty propertyView = new JPAEdmProperty(JPAEdmEntityType.this.schemaView);
                propertyView.getBuilder().build();
                JPAEdmEntityType.this.currentEdmEntityType.setProperties(propertyView.getEdmPropertyList());
                if (propertyView.getJPAEdmNavigationPropertyView() != null && (navPropView = propertyView.getJPAEdmNavigationPropertyView()).getConsistentEdmNavigationProperties() != null && !navPropView.getConsistentEdmNavigationProperties().isEmpty()) {
                    JPAEdmEntityType.this.currentEdmEntityType.setNavigationProperties(navPropView.getConsistentEdmNavigationProperties());
                }
                JPAEdmKeyView keyView = propertyView.getJPAEdmKeyView();
                JPAEdmEntityType.this.currentEdmEntityType.setKey(keyView.getEdmKey());
                JPAEdmEntityType.this.consistentEntityTypes.add(JPAEdmEntityType.this.currentEdmEntityType);
                JPAEdmEntityType.this.consistentEntityTypeMap.put(JPAEdmEntityType.this.currentJPAEntityType.getName(), JPAEdmEntityType.this.currentEdmEntityType);
            }
        }

        private List<javax.persistence.metamodel.EntityType<?>> sortJPAEntityTypes(Collection<javax.persistence.metamodel.EntityType<?>> entities) {
            ArrayList entityTypeList = new ArrayList(entities.size());
            while (!entities.isEmpty()) {
                Iterator<javax.persistence.metamodel.EntityType<?>> itr = entities.iterator();
                javax.persistence.metamodel.EntityType<?> smallestJpaEntity = itr.next();
                while (itr.hasNext()) {
                    javax.persistence.metamodel.EntityType<?> currentJpaEntity = itr.next();
                    if (smallestJpaEntity.getName().compareTo(currentJpaEntity.getName()) <= 0) continue;
                    smallestJpaEntity = currentJpaEntity;
                }
                entityTypeList.add(smallestJpaEntity);
                entities.remove(smallestJpaEntity);
            }
            return entityTypeList;
        }

        private boolean isExcluded(JPAEdmEntityType jpaEdmEntityType) {
            JPAEdmMappingModelAccess mappingModelAccess = jpaEdmEntityType.getJPAEdmMappingModelAccess();
            return mappingModelAccess != null && mappingModelAccess.isMappingModelExists() && mappingModelAccess.checkExclusionOfJPAEntityType(jpaEdmEntityType.getJPAEntityType().getName());
        }
    }
}

