/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.datacache;

import java.util.Collection;
import org.apache.openjpa.datacache.AbstractQueryCache;
import org.apache.openjpa.datacache.DataCacheManager;
import org.apache.openjpa.datacache.QueryKey;
import org.apache.openjpa.datacache.QueryResult;
import org.apache.openjpa.event.RemoteCommitListener;
import org.apache.openjpa.util.CacheMap;

public class ConcurrentQueryCache
extends AbstractQueryCache
implements RemoteCommitListener {
    private CacheMap _cache;
    protected boolean _lru = false;
    private int _cacheSize = Integer.MIN_VALUE;
    private int _softRefs = Integer.MIN_VALUE;

    public CacheMap getCacheMap() {
        return this._cache;
    }

    public int getCacheSize() {
        return this._cache.getCacheSize();
    }

    public void setCacheSize(int size) {
        this._cacheSize = size;
    }

    public int getSoftReferenceSize() {
        return this._cache.getSoftReferenceSize();
    }

    public void setSoftReferenceSize(int size) {
        this._softRefs = size;
    }

    @Override
    public void initialize(DataCacheManager mgr) {
        super.initialize(mgr);
        this.conf.getRemoteCommitEventManager().addInternalListener(this);
        this._cache = this.newCacheMap();
        if (this._cacheSize != Integer.MIN_VALUE) {
            this._cache.setCacheSize(this._cacheSize);
        }
        if (this._softRefs != Integer.MIN_VALUE) {
            this._cache.setSoftReferenceSize(this._softRefs);
        }
    }

    @Override
    public void writeLock() {
        this._cache.writeLock();
    }

    @Override
    public void writeUnlock() {
        this._cache.writeUnlock();
    }

    protected CacheMap newCacheMap() {
        CacheMap res = new CacheMap(this._lru);
        return res;
    }

    @Override
    protected QueryResult getInternal(QueryKey qk) {
        return (QueryResult)this._cache.get(qk);
    }

    @Override
    protected QueryResult putInternal(QueryKey qk, QueryResult result) {
        return (QueryResult)this._cache.put(qk, result);
    }

    @Override
    protected QueryResult removeInternal(QueryKey qk) {
        return (QueryResult)this._cache.remove(qk);
    }

    @Override
    protected void clearInternal() {
        this._cache.clear();
    }

    @Override
    protected boolean pinInternal(QueryKey qk) {
        return this._cache.pin(qk);
    }

    @Override
    protected boolean unpinInternal(QueryKey qk) {
        return this._cache.unpin(qk);
    }

    @Override
    protected Collection keySet() {
        return this._cache.keySet();
    }

    @Override
    public AbstractQueryCache.EvictPolicy getEvictPolicy() {
        return this.evictPolicy;
    }

    public void setLru(boolean l) {
        this._lru = l;
    }

    public boolean getLru() {
        return this._lru;
    }
}

