/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.openjpa.lib.util.J2DoPrivHelper;

public class MultiClassLoader
extends ClassLoader {
    public static final ClassLoader THREAD_LOADER = null;
    public static final ClassLoader SYSTEM_LOADER = AccessController.doPrivileged(J2DoPrivHelper.getSystemClassLoaderAction());
    private List<ClassLoader> _loaders = new ArrayList<ClassLoader>(5);

    public MultiClassLoader() {
        super(null);
    }

    public MultiClassLoader(MultiClassLoader other) {
        super(null);
        this.addClassLoaders(other);
    }

    public boolean containsClassLoader(ClassLoader loader) {
        return this._loaders.contains(loader);
    }

    public ClassLoader[] getClassLoaders() {
        ClassLoader[] loaders = new ClassLoader[this.size()];
        Iterator<ClassLoader> itr = this._loaders.iterator();
        for (int i = 0; i < loaders.length; ++i) {
            ClassLoader loader = itr.next();
            if (loader == THREAD_LOADER) {
                loader = AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
            }
            loaders[i] = loader;
        }
        return loaders;
    }

    public ClassLoader getClassLoader(int index) {
        ClassLoader loader = this._loaders.get(index);
        if (loader == THREAD_LOADER) {
            loader = AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        }
        return loader;
    }

    public boolean addClassLoader(ClassLoader loader) {
        if (this._loaders.contains(loader)) {
            return false;
        }
        return this._loaders.add(loader);
    }

    public boolean addClassLoader(int index, ClassLoader loader) {
        if (this._loaders.contains(loader)) {
            return false;
        }
        this._loaders.add(index, loader);
        return true;
    }

    public void setClassLoaders(MultiClassLoader multi) {
        this.clear();
        this.addClassLoaders(multi);
    }

    public boolean addClassLoaders(int index, MultiClassLoader multi) {
        if (multi == null) {
            return false;
        }
        boolean added = false;
        Iterator<ClassLoader> itr = multi._loaders.iterator();
        while (itr.hasNext()) {
            if (!this.addClassLoader(index, itr.next())) continue;
            ++index;
            added = true;
        }
        return added;
    }

    public boolean addClassLoaders(MultiClassLoader multi) {
        if (multi == null) {
            return false;
        }
        boolean added = false;
        Iterator<ClassLoader> itr = multi._loaders.iterator();
        while (itr.hasNext()) {
            added = this.addClassLoader(itr.next()) || added;
        }
        return added;
    }

    public boolean removeClassLoader(ClassLoader loader) {
        return this._loaders.remove(loader);
    }

    public void clear() {
        this._loaders.clear();
    }

    public int size() {
        return this._loaders.size();
    }

    public boolean isEmpty() {
        return this._loaders.isEmpty();
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (ClassLoader loader : this._loaders) {
            if (loader == THREAD_LOADER) {
                loader = AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
            }
            try {
                return Class.forName(name, false, loader);
            }
            catch (Throwable t) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected URL findResource(String name) {
        for (ClassLoader loader : this._loaders) {
            URL rsrc;
            if (loader == THREAD_LOADER) {
                loader = AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
            }
            if (loader == null || (rsrc = AccessController.doPrivileged(J2DoPrivHelper.getResourceAction(loader, name))) == null) continue;
            return rsrc;
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        Vector<URL> all = new Vector<URL>();
        for (ClassLoader loader : this._loaders) {
            if (loader == THREAD_LOADER) {
                loader = AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
            }
            if (loader == null) continue;
            try {
                Enumeration<URL> rsrcs = AccessController.doPrivileged(J2DoPrivHelper.getResourcesAction(loader, name));
                while (rsrcs.hasMoreElements()) {
                    URL rsrc = rsrcs.nextElement();
                    if (all.contains(rsrc)) continue;
                    all.addElement(rsrc);
                }
            }
            catch (PrivilegedActionException pae) {
                throw (IOException)pae.getException();
            }
        }
        return all.elements();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MultiClassLoader)) {
            return false;
        }
        return ((Object)((MultiClassLoader)other)._loaders).equals(this._loaders);
    }

    public int hashCode() {
        return ((Object)this._loaders).hashCode();
    }
}

