/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.util;

import com.github.caldav4j.CalDAVConstants;
import com.github.caldav4j.exceptions.CalDAV4JException;
import com.github.caldav4j.exceptions.CalDAV4JProtocolException;
import com.github.caldav4j.exceptions.DOMValidationException;
import com.github.caldav4j.model.request.CalDAVProp;
import com.github.caldav4j.model.request.CalendarData;
import com.github.caldav4j.model.request.CalendarQuery;
import com.github.caldav4j.model.request.Comp;
import com.github.caldav4j.model.request.CompFilter;
import com.github.caldav4j.model.request.PropFilter;
import com.github.caldav4j.util.UrlUtils;
import com.github.caldav4j.util.XMLUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;

public class GenerateQuery {
    private static final Logger log = LoggerFactory.getLogger(GenerateQuery.class);
    private String requestedComponent = null;
    private List<String> requestedComponentProperties = new ArrayList<String>();
    private String filterComponent = null;
    private List<String> filterComponentProperties = new ArrayList<String>();
    private Date timeRangeStart = null;
    private Date timeRangeEnd = null;
    private boolean allProp = true;
    private boolean noCalendarData = false;
    private String collation = null;
    private Date recurrenceSetEnd;
    private Date recurrenceSetStart;
    private Integer expandOrLimit;

    public void setNoCalendarData(boolean p) {
        this.noCalendarData = p;
    }

    public GenerateQuery(String component, String filterComponent) throws CalDAV4JException {
        this.setComponent(component);
        this.setFilter(filterComponent);
    }

    public GenerateQuery() {
    }

    protected GenerateQuery(String c, List<String> cProp, String cFilter, List<String> pFilter) {
        this(c, cProp, cFilter, pFilter, null);
    }

    protected GenerateQuery(String c, List<String> cProp, String cFilter, List<String> pFilter, String collation) {
        this.setComponent(c, cProp);
        this.setFilter(cFilter, pFilter);
        this.collation = collation;
    }

    private GenerateQuery(String c, String[] cProp, String cFilter, String[] pFilter) {
        this(c, cProp != null ? Arrays.asList(cProp) : null, cFilter, pFilter != null ? Arrays.asList(pFilter) : null);
    }

    public boolean validate() {
        return true;
    }

    public void setComponent(String component) {
        if (component != null) {
            String[] cl = null;
            String[] c = component.trim().split("\\s*:\\s*", 2);
            this.setRequestedComponent(c[0]);
            if (c.length > 1) {
                this.allProp = false;
                cl = c[1].trim().split("\\s*,\\s*");
                this.requestedComponentProperties = Arrays.asList(cl);
            }
        }
    }

    public void setComponent(String component, List<String> props) {
        if (component != null) {
            this.setRequestedComponent(component);
            this.requestedComponentProperties = props;
        }
    }

    private Comp getComp() {
        Comp vCalendarComp = new Comp();
        vCalendarComp.setName("VCALENDAR");
        if (this.requestedComponent != null) {
            Comp vEventComp = new Comp();
            vEventComp.setName(this.requestedComponent);
            for (String propertyName : this.requestedComponentProperties) {
                vEventComp.addProp(new CalDAVProp(propertyName, false, false));
            }
            ArrayList<Comp> comps = new ArrayList<Comp>();
            try {
                vEventComp.validate();
                comps.add(vEventComp);
            }
            catch (DOMValidationException e) {
                log.warn("Comp not valid");
            }
            vCalendarComp.setComps(comps);
        }
        return vCalendarComp;
    }

    public void setFilter(String filterComponent) throws CalDAV4JException {
        if (filterComponent != null) {
            String[] c = filterComponent.split("\\s*:\\s*", 2);
            Pattern compFilterString = Pattern.compile("(.+?)\\s*(\\[(.*?);(.*?)\\])?");
            Matcher m = compFilterString.matcher(c[0]);
            if (m.matches()) {
                this.setFilterComponent(m.group(1));
                if (m.group(4) != null) {
                    this.timeRangeStart = this.parseTime(m.group(3));
                    this.timeRangeEnd = this.parseTime(m.group(4));
                }
                if (c.length > 1) {
                    String[] cl = c[1].trim().split("\\s*,\\s*");
                    this.filterComponentProperties = Arrays.asList(cl);
                }
            }
        }
    }

    public void setFilter(String filterComponent, List<String> props) {
        if (filterComponent != null) {
            this.setFilterComponent(filterComponent);
            this.setFilterComponentProperties(props);
        }
    }

    private List<PropFilter> getPropFilters() throws CalDAV4JException {
        ArrayList<PropFilter> pf = new ArrayList<PropFilter>();
        Pattern filter = Pattern.compile("(.+?)([!=]=)(\\[(.*?);(.*?)\\]|([^\\]].+))");
        for (String p : this.filterComponentProperties) {
            String name = null;
            Boolean isDefined = null;
            boolean negateCondition = false;
            Date timeRangeStart = null;
            Date timeRangeEnd = null;
            Boolean isTextmatchcaseless = true;
            String textmatchString = null;
            Matcher str = filter.matcher(p);
            if (str.matches() && str.group(3) != null) {
                List<String> componentList;
                name = str.group(1);
                negateCondition = "!=".equals(str.group(2));
                if (str.group(4) == null) {
                    if ("UNDEF".equals(str.group(3))) {
                        isDefined = false;
                    } else {
                        textmatchString = str.group(3);
                    }
                } else if (str.group(5) != null) {
                    timeRangeStart = this.parseTime(str.group(4));
                    timeRangeEnd = this.parseTime(str.group(5));
                }
                if ((componentList = Arrays.asList("VALARM", "VEVENT", "VFREEBUSY", "VJOURNAL", "VTIMEZONE", "VTODO", "VVENUE")).contains(name)) continue;
                pf.add(new PropFilter(name, isDefined, timeRangeStart, timeRangeEnd, isTextmatchcaseless, negateCondition, this.collation, textmatchString, null));
                continue;
            }
            log.warn("Not a valid filter");
        }
        return pf;
    }

    private CompFilter getFilter() throws CalDAV4JException {
        CompFilter vCalendarCompFilter = new CompFilter();
        vCalendarCompFilter.setName("VCALENDAR");
        if (this.filterComponent != null) {
            CompFilter vEventCompFilter = new CompFilter(this.filterComponent, false, this.timeRangeStart, this.timeRangeEnd, null, this.getPropFilters().size() == 0 ? null : this.getPropFilters());
            try {
                vEventCompFilter.validate();
                vCalendarCompFilter.addCompFilter(vEventCompFilter);
            }
            catch (DOMValidationException e) {
                log.warn("CompFilter is not valid");
            }
        }
        return vCalendarCompFilter;
    }

    public CalendarQuery generateQuery() throws CalDAV4JException {
        return this.generate();
    }

    public CalendarQuery generate() throws CalDAV4JException {
        CalendarQuery query = new CalendarQuery();
        query.addProperty((XmlSerializable)CalDAVConstants.DNAME_GETETAG);
        if (this.allProp) {
            query.addProperty((XmlSerializable)CalDAVConstants.DNAME_ALLPROP);
        }
        if (!this.noCalendarData) {
            CalendarData calendarData = new CalendarData();
            if (this.recurrenceSetEnd != null || this.recurrenceSetStart != null) {
                calendarData.setExpandOrLimitRecurrenceSet(this.expandOrLimit);
                calendarData.setRecurrenceSetStart(this.recurrenceSetStart);
                calendarData.setRecurrenceSetEnd(this.recurrenceSetEnd);
            }
            calendarData.setComp(this.getComp());
            query.setCalendarDataProp(calendarData);
        } else if (this.recurrenceSetEnd != null || this.recurrenceSetStart != null) {
            throw new CalDAV4JProtocolException("Bad query: you set noCalendarData but you have limit-recurrence-set");
        }
        query.setCompFilter(this.getFilter());
        query.validate();
        return query;
    }

    public String prettyPrint() {
        try {
            Document doc = this.generate().createNewDocument();
            return XMLUtils.toPrettyXML(doc);
        }
        catch (DOMValidationException domve) {
            throw new RuntimeException(domve);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setRequestedComponent(String c) {
        if (c != null) {
            this.requestedComponent = c.trim();
        }
    }

    public void setFilterComponent(String c) {
        if (c != null) {
            this.filterComponent = c.trim();
        }
    }

    public void setFilterComponentProperties(List<String> a) {
        if (a != null) {
            this.filterComponentProperties = a;
        }
    }

    public void setRequestedComponentProperties(List<String> requestedComponentProperties) {
        if (requestedComponentProperties != null) {
            this.requestedComponentProperties = requestedComponentProperties;
        }
    }

    public void setTimeRange(Date start, Date end) {
        this.timeRangeStart = start;
        this.timeRangeEnd = end;
    }

    public void setRecurrenceSet(String start, String end, Integer expandOrLimit) {
        if (UrlUtils.isNotBlank(start)) {
            try {
                this.recurrenceSetStart = this.parseTime(start);
            }
            catch (CalDAV4JException e) {
                e.printStackTrace();
            }
        }
        if (UrlUtils.isNotBlank(end)) {
            try {
                this.recurrenceSetEnd = this.parseTime(end);
            }
            catch (CalDAV4JException e) {
                e.printStackTrace();
            }
        }
        switch (expandOrLimit) {
            case 0: 
            case 1: {
                this.expandOrLimit = expandOrLimit;
                break;
            }
        }
    }

    public static String printQuery(CalendarQuery query) throws DOMValidationException {
        try {
            query.validate();
            Document doc = query.createNewDocument();
            return XMLUtils.toPrettyXML(doc);
        }
        catch (DOMException e) {
            throw new DOMValidationException(e.getMessage(), e);
        }
    }

    private Date parseTime(String time) throws CalDAV4JException {
        if (time != null && !"".equals(time)) {
            if ("NOW".equals(time)) {
                return new DateTime(true);
            }
            try {
                if (time.length() > 8) {
                    return new DateTime(time);
                }
                return new Date(time);
            }
            catch (ParseException e) {
                throw new CalDAV4JException("Unparsable date format in query:" + time, e);
            }
        }
        return null;
    }
}

