/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.admin.backup;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.progress.UpdatableProgressBar;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.core.markup.html.bootstrap.utilities.BackgroundColorBehavior;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome6IconType;
import jakarta.inject.Inject;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.openmeetings.backup.BackupExport;
import org.apache.openmeetings.util.CalendarPatterns;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.web.admin.AdminBasePanel;
import org.apache.openmeetings.web.admin.backup.BackupUploadResourceReference;
import org.apache.openmeetings.web.common.BasePanel;
import org.apache.openmeetings.web.common.upload.UploadForm;
import org.apache.openmeetings.web.util.ThreadHelper;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.AjaxDownloadBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.FileSystemResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthorizeInstantiation(value={"ADMIN", "ADMIN_BACKUP"})
public class BackupPanel
extends AdminBasePanel {
    private static final Logger log = LoggerFactory.getLogger(BackupPanel.class);
    private static final long serialVersionUID = 1L;
    private final NotificationPanel feedback = new NotificationPanel("feedback");
    private UploadForm upload;
    @Inject
    private BackupExport backupExport;

    public BackupPanel(String id) {
        super(id);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.upload = new UploadForm("upload", String.valueOf(RequestCycle.get().urlFor((ResourceReference)new BackupUploadResourceReference(), new PageParameters()))){
            private static final long serialVersionUID = 1L;

            @Override
            protected String uploadLocation() {
                return ".backup-upload .card-footer";
            }

            @Override
            protected boolean allowMultiple() {
                return false;
            }

            @Override
            protected boolean showDescBlock() {
                return false;
            }

            @Override
            protected String buttonLabelKey() {
                return "admin.backup.import.lbl";
            }

            @Override
            protected String processingLabelKey() {
                return "admin.backup.import.lbl";
            }
        };
        this.add(new Component[]{this.feedback.setOutputMarkupId(true), new BackupForm("backupUpload"), this.upload, new Label("cmdLineDesc", (IModel)new ResourceModel("admin.backup.cmd.line.desc")).setEscapeModelStrings(false).setRenderBodyOnly(true)});
    }

    @Override
    public BasePanel onMenuPanelLoad(IPartialPageRequestHandler handler) {
        this.upload.show(handler);
        return super.onMenuPanelLoad(handler);
    }

    private class BackupForm
    extends Form<Void> {
        private static final long serialVersionUID = 1L;
        private final Model<Boolean> includeFilesInBackup;
        private UpdatableProgressBar progressBar;
        private File backupFile;
        private Throwable th;
        private final AtomicInteger progress;
        private BootstrapAjaxButton download;

        public BackupForm(String id) {
            super(id);
            this.includeFilesInBackup = Model.of((Serializable)Boolean.valueOf(true));
            this.th = null;
            this.progress = new AtomicInteger();
            this.setMultiPart(true);
        }

        protected void onInitialize() {
            this.add(new Component[]{new CheckBox("includeFilesInBackup", this.includeFilesInBackup).setOutputMarkupId(true)});
            final AjaxDownloadBehavior downloader = new AjaxDownloadBehavior(new IResource(){
                private static final long serialVersionUID = 1L;

                public void respond(IResource.Attributes attributes) {
                    new FileSystemResource(BackupForm.this.backupFile.toPath()){
                        private static final long serialVersionUID = 1L;

                        protected AbstractResource.ResourceResponse createResourceResponse(IResource.Attributes attr, Path path) {
                            AbstractResource.ResourceResponse response = super.createResourceResponse(attr, path);
                            response.setCacheDuration(Duration.ZERO);
                            return response;
                        }
                    }.respond(attributes);
                }
            });
            this.download = new BootstrapAjaxButton("download", (IModel)new ResourceModel("admin.backup.lbl"), this, Buttons.Type.Outline_Primary){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target) {
                    String dateString = "backup_" + CalendarPatterns.getTimeForStreamId((Date)new Date());
                    BackupForm.this.backupFile = new File(OmFileHelper.getUploadBackupDir(), dateString + ".zip");
                    BackupForm.this.startWithProgress(() -> {
                        try {
                            BackupPanel.this.backupExport.performExport(BackupForm.this.backupFile, ((Boolean)BackupForm.this.includeFilesInBackup.getObject()).booleanValue(), BackupForm.this.progress);
                        }
                        catch (Exception e) {
                            log.error("Exception on panel backup download ", (Throwable)e);
                            BackupForm.this.th = e;
                        }
                    }, dateString, target);
                }

                protected void onError(AjaxRequestTarget target) {
                    target.add(new Component[]{BackupPanel.this.feedback});
                }
            };
            this.download.setIconType((IconType)FontAwesome6IconType.file_arrow_down_s);
            this.progressBar = new UpdatableProgressBar("progress", (IModel)new Model((Serializable)Integer.valueOf(0)), BackgroundColorBehavior.Color.Info, true){
                private static final long serialVersionUID = 1L;

                protected IModel<Integer> newValue() {
                    return Model.of((Serializable)Integer.valueOf(BackupForm.this.progress.get()));
                }

                protected void onPostProcessTarget(IPartialPageRequestHandler target) {
                    if (BackupForm.this.th != null) {
                        this.stop(target);
                        BackupPanel.this.feedback.error((Serializable)((Object)BackupForm.this.th.getMessage()));
                        this.onComplete(target);
                    }
                    super.onPostProcessTarget(target);
                }

                protected void onComplete(IPartialPageRequestHandler target) {
                    BackupForm.this.progressBar.setVisible(false);
                    target.add(new Component[]{BackupPanel.this.feedback});
                    BackupForm.this.updateButtons(target, true);
                    downloader.initiate(target);
                    super.onComplete(target);
                }
            };
            this.progressBar.updateInterval(Duration.ofSeconds(1L)).stop(null).striped(false).setVisible(false).setOutputMarkupPlaceholderTag(true);
            this.add(new Behavior[]{downloader});
            this.add(new Component[]{this.progressBar, this.download, new Label("backupSteps", (IModel)new ResourceModel("admin.backup.steps")).setEscapeModelStrings(false).setRenderBodyOnly(true)});
            super.onInitialize();
        }

        private void updateButtons(IPartialPageRequestHandler target, boolean enabled) {
            target.add(new Component[]{this.download.setEnabled(enabled)});
        }

        private void startWithProgress(Runnable r, String label, AjaxRequestTarget target) {
            this.th = null;
            this.progress.set(0);
            ThreadHelper.startRunnable(r, "Openmeetings - " + label);
            this.updateButtons((IPartialPageRequestHandler)target, false);
            target.add(new Component[]{BackupPanel.this.feedback, ((GenericPanel)this.progressBar.restart((IPartialPageRequestHandler)target).setModelObject((Object)0)).setVisible(true)});
        }

        protected void onDetach() {
            this.includeFilesInBackup.detach();
            super.onDetach();
        }
    }
}

