/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config.impl;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.config.ClientUserCodeDeploymentConfig;
import com.hazelcast.client.config.impl.ClientDomConfigProcessor;
import com.hazelcast.client.config.impl.QueryCacheYamlConfigBuilderHelper;
import com.hazelcast.config.ClassFilter;
import com.hazelcast.config.CompactSerializationConfig;
import com.hazelcast.config.CompactSerializationConfigAccessor;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.GlobalSerializerConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.PersistentMemoryConfig;
import com.hazelcast.config.PersistentMemoryDirectoryConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.config.security.JaasAuthenticationConfig;
import com.hazelcast.config.security.RealmConfig;
import com.hazelcast.config.security.TokenEncoding;
import com.hazelcast.config.security.TokenIdentityConfig;
import com.hazelcast.internal.config.DomConfigHelper;
import com.hazelcast.internal.util.StringUtil;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class YamlClientDomConfigProcessor
extends ClientDomConfigProcessor {
    public YamlClientDomConfigProcessor(boolean domLevel3, ClientConfig clientConfig) {
        super(domLevel3, clientConfig, new QueryCacheYamlConfigBuilderHelper());
    }

    public YamlClientDomConfigProcessor(boolean domLevel3, ClientConfig clientConfig, boolean strict) {
        super(domLevel3, clientConfig, new QueryCacheYamlConfigBuilderHelper(strict), strict);
    }

    @Override
    protected void handleClusterMembers(Node node, ClientNetworkConfig clientNetworkConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            clientNetworkConfig.addAddress(this.getTextContent(child));
        }
    }

    @Override
    protected void handleOutboundPorts(Node child, ClientNetworkConfig clientNetworkConfig) {
        for (Node n : DomConfigHelper.childElements(child)) {
            String value = this.getTextContent(n);
            clientNetworkConfig.addOutboundPortDefinition(value);
        }
    }

    @Override
    protected SerializationConfig parseSerialization(Node node) {
        SerializationConfig serializationConfig = new SerializationConfig();
        for (Node child : DomConfigHelper.childElements(node)) {
            String name = DomConfigHelper.cleanNodeName(child);
            if (this.matches("portable-version", name)) {
                serializationConfig.setPortableVersion(DomConfigHelper.getIntegerValue(name, this.getTextContent(child)));
                continue;
            }
            if (this.matches("check-class-def-errors", name)) {
                serializationConfig.setCheckClassDefErrors(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if (this.matches("use-native-byte-order", name)) {
                serializationConfig.setUseNativeByteOrder(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if (this.matches("byte-order", name)) {
                ByteOrder byteOrder = null;
                if (ByteOrder.BIG_ENDIAN.toString().equals(this.getTextContent(child))) {
                    byteOrder = ByteOrder.BIG_ENDIAN;
                } else if (ByteOrder.LITTLE_ENDIAN.toString().equals(this.getTextContent(child))) {
                    byteOrder = ByteOrder.LITTLE_ENDIAN;
                }
                serializationConfig.setByteOrder(byteOrder != null ? byteOrder : ByteOrder.BIG_ENDIAN);
                continue;
            }
            if (this.matches("enable-compression", name)) {
                serializationConfig.setEnableCompression(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if (this.matches("enable-shared-object", name)) {
                serializationConfig.setEnableSharedObject(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if (this.matches("allow-unsafe", name)) {
                serializationConfig.setAllowUnsafe(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if (this.matches("allow-override-default-serializers", name)) {
                serializationConfig.setAllowOverrideDefaultSerializers(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if (this.matches("data-serializable-factories", name)) {
                this.fillDataSerializableFactories(child, serializationConfig);
                continue;
            }
            if (this.matches("portable-factories", name)) {
                this.fillPortableFactories(child, serializationConfig);
                continue;
            }
            if (this.matches("serializers", name)) {
                this.fillSerializers(child, serializationConfig);
                continue;
            }
            if (this.matches("global-serializer", name)) {
                this.fillGlobalSerializer(child, serializationConfig);
                continue;
            }
            if (this.matches("java-serialization-filter", name)) {
                this.fillJavaSerializationFilter(child, serializationConfig);
                continue;
            }
            if (!this.matches("compact-serialization", name)) continue;
            this.handleCompactSerialization(child, serializationConfig);
        }
        return serializationConfig;
    }

    @Override
    protected String parseCustomLoadBalancerClassName(Node node) {
        return this.getAttribute(node, "class-name");
    }

    @Override
    protected void handleCompactSerialization(Node node, SerializationConfig serializationConfig) {
        CompactSerializationConfig compactSerializationConfig = serializationConfig.getCompactSerializationConfig();
        for (Node child : DomConfigHelper.childElements(node)) {
            String name = DomConfigHelper.cleanNodeName(child);
            if (this.matches("serializers", name)) {
                this.fillCompactSerializers(child, compactSerializationConfig);
                continue;
            }
            if (!this.matches("classes", name)) continue;
            this.fillCompactSerializableClasses(child, compactSerializationConfig);
        }
    }

    @Override
    protected void fillCompactSerializers(Node node, CompactSerializationConfig compactSerializationConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            String serializerClassName = this.getAttribute(child, "serializer");
            CompactSerializationConfigAccessor.registerSerializer(compactSerializationConfig, serializerClassName);
        }
    }

    @Override
    protected void fillCompactSerializableClasses(Node node, CompactSerializationConfig compactSerializationConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            String compactSerializableClassName = this.getAttribute(child, "class");
            CompactSerializationConfigAccessor.registerClass(compactSerializationConfig, compactSerializableClassName);
        }
    }

    private void fillGlobalSerializer(Node child, SerializationConfig serializationConfig) {
        GlobalSerializerConfig globalSerializerConfig = new GlobalSerializerConfig();
        String attrClassName = this.getAttribute(child, "class-name");
        String attrOverrideJavaSerialization = this.getAttribute(child, "override-java-serialization");
        boolean overrideJavaSerialization = attrOverrideJavaSerialization != null && DomConfigHelper.getBooleanValue(attrOverrideJavaSerialization.trim());
        globalSerializerConfig.setClassName(attrClassName);
        globalSerializerConfig.setOverrideJavaSerialization(overrideJavaSerialization);
        serializationConfig.setGlobalSerializerConfig(globalSerializerConfig);
    }

    @Override
    protected void fillSerializers(Node node, SerializationConfig serializationConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            SerializerConfig serializerConfig = new SerializerConfig();
            String typeClassName = this.getAttribute(child, "type-class");
            String className = this.getAttribute(child, "class-name");
            serializerConfig.setTypeClassName(typeClassName);
            serializerConfig.setClassName(className);
            serializationConfig.addSerializerConfig(serializerConfig);
        }
    }

    @Override
    protected void fillDataSerializableFactories(Node node, SerializationConfig serializationConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            Node factoryIdNode = this.getNamedItemNode(child, "factory-id");
            Node classNameNode = this.getNamedItemNode(child, "class-name");
            if (factoryIdNode == null) {
                throw new IllegalArgumentException("'factory-id' attribute of 'data-serializable-factory' is required!");
            }
            if (classNameNode == null) {
                throw new IllegalArgumentException("'class-name' attribute of 'data-serializable-factory' is required!");
            }
            int factoryId = Integer.parseInt(this.getTextContent(factoryIdNode));
            String className = this.getTextContent(classNameNode);
            serializationConfig.addDataSerializableFactoryClass(factoryId, className);
        }
    }

    @Override
    protected void fillPortableFactories(Node node, SerializationConfig serializationConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            Node factoryIdNode = this.getNamedItemNode(child, "factory-id");
            Node classNameNode = this.getNamedItemNode(child, "class-name");
            if (factoryIdNode == null) {
                throw new IllegalArgumentException("'factory-id' attribute of 'portable-factory' is required!");
            }
            if (classNameNode == null) {
                throw new IllegalArgumentException("'class-name' attribute of 'portable-factory' is required!");
            }
            int factoryId = Integer.parseInt(this.getTextContent(factoryIdNode));
            String className = this.getTextContent(classNameNode);
            serializationConfig.addPortableFactoryClass(factoryId, className);
        }
    }

    @Override
    protected ClassFilter parseClassFilterList(Node node) {
        ClassFilter list = new ClassFilter();
        for (Node typeNode : DomConfigHelper.childElements(node)) {
            String name = DomConfigHelper.cleanNodeName(typeNode);
            if (this.matches("class", name)) {
                for (Node classNode : DomConfigHelper.childElements(typeNode)) {
                    list.addClasses(this.getTextContent(classNode));
                }
                continue;
            }
            if (this.matches("package", name)) {
                for (Node packageNode : DomConfigHelper.childElements(typeNode)) {
                    list.addPackages(this.getTextContent(packageNode));
                }
                continue;
            }
            if (!this.matches("prefix", name)) continue;
            for (Node prefixNode : DomConfigHelper.childElements(typeNode)) {
                list.addPrefixes(this.getTextContent(prefixNode));
            }
        }
        return list;
    }

    @Override
    protected void handleUserCodeDeploymentNode(ClientUserCodeDeploymentConfig userCodeDeploymentConfig, Node child) {
        block3: {
            String childNodeName;
            block2: {
                childNodeName = DomConfigHelper.cleanNodeName(child);
                if (!this.matches("classnames", childNodeName)) break block2;
                for (Node classNameNode : DomConfigHelper.childElements(child)) {
                    userCodeDeploymentConfig.addClass(this.getTextContent(classNameNode));
                }
                break block3;
            }
            if (!this.matches("jarpaths", childNodeName)) break block3;
            for (Node jarPathNode : DomConfigHelper.childElements(child)) {
                userCodeDeploymentConfig.addJar(this.getTextContent(jarPathNode));
            }
        }
    }

    @Override
    protected void handleListeners(Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            String className = this.getTextContent(child);
            this.clientConfig.addListenerConfig(new ListenerConfig(className));
        }
    }

    @Override
    protected void handleNearCache(Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            this.handleNearCacheNode(child);
        }
    }

    @Override
    protected void handleReliableTopic(Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            this.handleReliableTopicNode(child);
        }
    }

    @Override
    protected void handleFlakeIdGenerator(Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            this.handleFlakeIdGeneratorNode(child);
        }
    }

    @Override
    protected void handleProxyFactoryNode(Node child) {
        this.handleProxyFactory(child);
    }

    @Override
    protected String getName(Node node) {
        return node.getNodeName();
    }

    @Override
    protected void fillProperties(Node node, Map<String, Comparable> properties) {
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            properties.put(childNode.getNodeName(), (Comparable)((Object)childNode.getNodeValue()));
        }
    }

    @Override
    protected void fillProperties(Node node, Properties properties) {
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            properties.setProperty(childNode.getNodeName(), childNode.getNodeValue());
        }
    }

    @Override
    protected void handleDiscoveryStrategies(Node node, ClientNetworkConfig clientNetworkConfig) {
        DiscoveryConfig discoveryConfig = clientNetworkConfig.getDiscoveryConfig();
        for (Node child : DomConfigHelper.childElements(node)) {
            String name = DomConfigHelper.cleanNodeName(child);
            if (this.matches("discovery-strategies", name)) {
                this.handleDiscoveryStrategiesNode(child, discoveryConfig);
                continue;
            }
            if (!this.matches("node-filter", name)) continue;
            this.handleDiscoveryNodeFilter(child, discoveryConfig);
        }
    }

    private void handleDiscoveryStrategiesNode(Node node, DiscoveryConfig discoveryConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            this.handleDiscoveryStrategy(child, discoveryConfig);
        }
    }

    @Override
    protected void handleTokenIdentity(ClientSecurityConfig clientSecurityConfig, Node node) {
        clientSecurityConfig.setTokenIdentityConfig(new TokenIdentityConfig(TokenEncoding.getTokenEncoding(this.getAttribute(node, "encoding")), this.getAttribute(node, "value")));
    }

    @Override
    protected void handleRealms(Node node, ClientSecurityConfig clientSecurityConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            this.handleRealm(child, clientSecurityConfig);
        }
    }

    @Override
    protected void handleJaasAuthentication(RealmConfig realmConfig, Node node) {
        JaasAuthenticationConfig jaasAuthenticationConfig = new JaasAuthenticationConfig();
        for (Node child : DomConfigHelper.childElements(node)) {
            jaasAuthenticationConfig.addLoginModuleConfig(this.handleLoginModule(child));
        }
        realmConfig.setJaasAuthenticationConfig(jaasAuthenticationConfig);
    }

    @Override
    protected void handlePersistentMemoryDirectory(PersistentMemoryConfig persistentMemoryConfig, Node dirNode) {
        String directory = this.getTextContent(this.getNamedItemNode(dirNode, "directory"));
        String numaNodeIdStr = this.getTextContent(this.getNamedItemNode(dirNode, "numa-node"));
        if (!StringUtil.isNullOrEmptyAfterTrim(numaNodeIdStr)) {
            int numaNodeId = DomConfigHelper.getIntegerValue("numa-node", numaNodeIdStr);
            persistentMemoryConfig.addDirectoryConfig(new PersistentMemoryDirectoryConfig(directory, numaNodeId));
        } else {
            persistentMemoryConfig.addDirectoryConfig(new PersistentMemoryDirectoryConfig(directory));
        }
    }
}

