/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import com.hazelcast.spi.annotation.PrivateApi;
import java.util.Arrays;

@PrivateApi
public enum ResourceType {
    CLASSPATH_RESOURCE(0),
    FILE(1),
    DIRECTORY(2),
    CLASS(3),
    JAR(4),
    JARS_IN_ZIP(5);

    private final int id;

    private ResourceType(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public boolean isClassArchive() {
        return this == JAR || this == JARS_IN_ZIP;
    }

    public static ResourceType getById(int id) {
        return Arrays.stream(ResourceType.values()).filter(resourceType -> resourceType.id == id).findFirst().orElse(null);
    }
}

