/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.operation.AbstractMapLocalOperation;
import com.hazelcast.spi.exception.DistributedObjectDestroyedException;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.operationservice.PartitionAwareOperation;
import com.hazelcast.spi.tenantcontrol.TenantControl;
import java.util.logging.Level;

public class MapPartitionDestroyOperation
extends AbstractMapLocalOperation
implements PartitionAwareOperation,
AllowedDuringPassiveState {
    private final PartitionContainer partitionContainer;

    public MapPartitionDestroyOperation(PartitionContainer partitionContainer, MapContainer mapContainer) {
        super(mapContainer);
        this.createRecordStoreOnDemand = false;
        this.partitionContainer = partitionContainer;
        this.mapContainer = mapContainer;
    }

    @Override
    protected void runInternal() {
        if (this.mapContainer == null) {
            return;
        }
        this.partitionContainer.destroyMap(this.mapContainer);
    }

    @Override
    public void logError(Throwable e) {
        if (e instanceof DistributedObjectDestroyedException) {
            ILogger logger = this.getLogger();
            logger.log(Level.FINEST, e.getMessage());
        } else {
            super.logError(e);
        }
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    public TenantControl getTenantControl() {
        return TenantControl.NOOP_TENANT_CONTROL;
    }
}

