/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.client;

import java.util.Objects;
import java.util.UUID;

public class SqlError {
    private final int code;
    private final String message;
    private final UUID originatingMemberId;
    private final boolean suggestionExists;
    private final String suggestion;
    private final boolean isCauseStackTraceExists;
    private final String causeStackTrace;

    public SqlError(int code, String message, UUID originatingMemberId, boolean suggestionExists, String suggestion, boolean isCauseStackTraceExists, String causeStackTrace) {
        this.code = code;
        this.message = message;
        this.originatingMemberId = originatingMemberId;
        this.suggestionExists = suggestionExists;
        this.suggestion = suggestion;
        this.isCauseStackTraceExists = isCauseStackTraceExists;
        this.causeStackTrace = causeStackTrace;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public UUID getOriginatingMemberId() {
        return this.originatingMemberId;
    }

    public String getSuggestion() {
        return this.suggestion;
    }

    public boolean isCauseStackTraceExists() {
        return this.isCauseStackTraceExists;
    }

    public String getCauseStackTrace() {
        return this.causeStackTrace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlError sqlError = (SqlError)o;
        if (this.code != sqlError.code) {
            return false;
        }
        if (!this.message.equals(sqlError.message)) {
            return false;
        }
        if (!this.originatingMemberId.equals(sqlError.originatingMemberId)) {
            return false;
        }
        if (this.suggestionExists && sqlError.suggestionExists && !Objects.equals(this.suggestion, sqlError.suggestion)) {
            return false;
        }
        return !this.isCauseStackTraceExists || !sqlError.isCauseStackTraceExists || Objects.equals(this.causeStackTrace, sqlError.causeStackTrace);
    }

    public int hashCode() {
        int result = this.code;
        result = 31 * result + this.message.hashCode();
        result = 31 * result + this.originatingMemberId.hashCode();
        result = 31 * result + Objects.hashCode(this.suggestion);
        result = 31 * result + Objects.hashCode(this.causeStackTrace);
        return result;
    }
}

