/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.action;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.action.AbstractActionManager;
import org.apache.pdfbox.preflight.action.ActionManagerFactory;
import org.apache.pdfbox.preflight.utils.COSUtils;

public class UriAction
extends AbstractActionManager {
    public UriAction(ActionManagerFactory amFact, COSDictionary adict, PreflightContext ctx, String aaKey) {
        super(amFact, adict, ctx, aaKey);
    }

    protected boolean innerValid() {
        COSBase uri = this.actionDictionnary.getItem(COSName.URI);
        if (uri == null) {
            this.context.addValidationError(new ValidationResult.ValidationError("6.1.1", "URI entry is mandatory for the UriAction"));
            return false;
        }
        COSDocument cosDocument = this.context.getDocument().getDocument();
        if (!COSUtils.isString(uri, cosDocument)) {
            this.context.addValidationError(new ValidationResult.ValidationError("6.1.3", "URI entry should be a string"));
            return false;
        }
        return true;
    }
}

