/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.cff.IndexData;
import org.apache.fontbox.cff.Type1CharStringParser;
import org.apache.fontbox.cff.Type1FontUtil;
import org.apache.pdfbox.encoding.Encoding;
import org.apache.pdfbox.encoding.MacRomanEncoding;
import org.apache.pdfbox.encoding.PdfDocEncoding;
import org.apache.pdfbox.encoding.StandardEncoding;
import org.apache.pdfbox.encoding.WinAnsiEncoding;
import org.apache.pdfbox.preflight.font.util.GlyphDescription;
import org.apache.pdfbox.preflight.font.util.PeekInputStream;
import org.apache.pdfbox.preflight.font.util.Type1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Type1Parser {
    public static final Log LOGGER = LogFactory.getLog(Type1Parser.class);
    protected static final char NAME_START = '/';
    protected static final String NOTDEF = "/.notdef";
    protected static final int DEFAULT_LEN_IV = 4;
    private static final String PS_STANDARD_ENCODING = "StandardEncoding";
    private static final String PS_ISOLATIN_ENCODING = "ISOLatin1Encoding";
    private static final String TOKEN_ENCODING = "US-ASCII";
    private PeekInputStream fontProgram = null;
    private int clearTextSize = 0;
    private int eexecSize = 0;
    private int numberOfReadBytes = 0;
    private Type1 type1Font = null;

    private Type1Parser(InputStream type1, int length1, int length2, Encoding enc) throws IOException {
        this.fontProgram = new PeekInputStream(type1);
        this.clearTextSize = length1;
        this.eexecSize = length2;
        this.type1Font = enc != null ? new Type1(enc) : new Type1((Encoding)new StandardEncoding());
        this.type1Font.addCidWithLabel(-1, NOTDEF);
    }

    public static Type1Parser createParser(InputStream fontProgram, int clearTextLength, int eexecLength) throws IOException {
        Encoding encoding = Type1Parser.getEncodingObject("");
        return Type1Parser.createParserWithEncodingObject(fontProgram, clearTextLength, eexecLength, encoding);
    }

    public static Type1Parser createParserWithEncodingName(InputStream fontProgram, int clearTextLength, int eexecLength, String encodingName) throws IOException {
        Encoding encoding = Type1Parser.getEncodingObject(encodingName);
        return Type1Parser.createParserWithEncodingObject(fontProgram, clearTextLength, eexecLength, encoding);
    }

    private static Encoding getEncodingObject(String encodingName) {
        StandardEncoding encoding = new StandardEncoding();
        if ("MacRomanEncoding".equals(encodingName)) {
            encoding = new MacRomanEncoding();
        } else if ("MacExpertEncoding".equals(encodingName)) {
            encoding = new MacRomanEncoding();
        } else if ("WinAnsiEncoding".equals(encodingName)) {
            encoding = new WinAnsiEncoding();
        } else if ("PDFDocEncoding".equals(encodingName)) {
            encoding = new PdfDocEncoding();
        }
        return encoding;
    }

    public static Type1Parser createParserWithEncodingObject(InputStream fontProgram, int clearTextLength, int eexecLength, Encoding encoding) throws IOException {
        return new Type1Parser(fontProgram, clearTextLength, eexecLength, encoding);
    }

    public Type1 parse() throws IOException {
        this.parseClearPartOfFontProgram(this.fontProgram);
        this.decodeAndParseEExecPart(this.fontProgram);
        return this.type1Font;
    }

    private void parseClearPartOfFontProgram(PeekInputStream stream) throws IOException {
        this.skipComments(stream);
        this.parseFontInformationUntilEncodingPart(stream);
    }

    private void decodeAndParseEExecPart(PeekInputStream stream) throws IOException {
        byte[] eexecPart = this.readEexec(stream);
        byte[] decodedEExecPart = this.decodeEexec(eexecPart);
        PeekInputStream eexecStream = new PeekInputStream(new ByteArrayInputStream(decodedEExecPart));
        this.parseEExecPart(eexecStream);
    }

    private void skipComments(PeekInputStream stream) throws IOException {
        int nextChar = stream.peek();
        while (nextChar == 37) {
            if (nextChar == -1) {
                throw new IOException("Unexpected End Of File during a comment parsing");
            }
            this.readLine(stream);
            nextChar = stream.peek();
        }
    }

    private void parseFontInformationUntilEncodingPart(PeekInputStream stream) throws IOException {
        byte[] token = this.readToken(stream);
        while (!this.isEExecKeyWord(token)) {
            if (this.isEncodingKeyWord(token)) {
                this.parseEncodingDefinition(stream);
            }
            token = this.readToken(stream);
        }
        while (!this.isStartOfEExecReached()) {
            this.readNextCharacter(stream);
        }
    }

    private void parseEncodingDefinition(PeekInputStream stream) throws IOException {
        byte[] token = this.readToken(stream);
        String readableToken = new String(token, TOKEN_ENCODING);
        if (PS_ISOLATIN_ENCODING.equals(readableToken)) {
            this.type1Font.initEncodingWithISOLatin1Encoding();
        } else if (PS_STANDARD_ENCODING.equals(readableToken)) {
            this.type1Font.initEncodingWithStandardEncoding();
        } else {
            try {
                Integer.parseInt(readableToken);
                this.throwExceptionIfUnexpectedToken("array", this.readToken(stream));
                this.readEndSetEncodingValues(stream);
            }
            catch (NumberFormatException e) {
                throw new IOException("Invalid encoding : Expected int value before \"array\" key word if the Encoding isn't Standard or ISOLatin");
            }
        }
    }

    private void parseEExecPart(PeekInputStream stream) throws IOException {
        int lenIV = 4;
        byte[] previousToken = new byte[]{};
        while (!this.isEndOfStream(stream)) {
            byte[] token = this.readToken(stream);
            if (this.isLenIVKeyWord(token)) {
                byte[] l = this.readToken(stream);
                lenIV = Integer.parseInt(new String(l, TOKEN_ENCODING));
            } else if (this.isBeginOfBinaryPart(token)) {
                try {
                    int lengthOfBinaryPart = Integer.parseInt(new String(previousToken, TOKEN_ENCODING));
                    this.skipSingleBlankSeparator(stream);
                    stream.read(new byte[lengthOfBinaryPart], 0, lengthOfBinaryPart);
                    token = this.readToken(stream);
                }
                catch (NumberFormatException e) {
                    throw new IOException("Binary part found but previous token wasn't an integer");
                }
            } else if (this.isCharStringKeyWord(token)) {
                this.parseCharStringArray(stream, lenIV);
            }
            previousToken = token;
        }
    }

    private void parseCharStringArray(PeekInputStream stream, int lenIV) throws IOException {
        this.goToBeginOfCharStringElements(stream);
        for (int numberOfElements = this.readNumberOfCharStrings(stream); numberOfElements > 0; --numberOfElements) {
            byte[] labelToken = this.readToken(stream);
            String label = new String(labelToken, TOKEN_ENCODING);
            if (label.equals("end")) {
                LOGGER.warn((Object)"[Type 1] Invalid number of elements in the CharString");
                break;
            }
            byte[] sizeOfCharStringToken = this.readToken(stream);
            int sizeOfCharString = Integer.parseInt(new String(sizeOfCharStringToken, TOKEN_ENCODING));
            this.readToken(stream);
            this.skipSingleBlankSeparator(stream);
            byte[] descBinary = new byte[sizeOfCharString];
            stream.read(descBinary, 0, sizeOfCharString);
            byte[] description = Type1FontUtil.charstringDecrypt((byte[])descBinary, (int)lenIV);
            Type1CharStringParser t1p = new Type1CharStringParser();
            List operations = t1p.parse(description, new IndexData(0));
            this.type1Font.addGlyphDescription(label, new GlyphDescription(operations));
            this.readToken(stream);
        }
    }

    private void goToBeginOfCharStringElements(PeekInputStream stream) throws IOException {
        byte[] token = new byte[]{};
        while (this.isNotBeginKeyWord(token = this.readToken(stream))) {
        }
    }

    private boolean isNotBeginKeyWord(byte[] token) throws IOException {
        String word = new String(token, TOKEN_ENCODING);
        return !"begin".equals(word);
    }

    private boolean isBeginOfBinaryPart(byte[] token) throws IOException {
        String word = new String(token, TOKEN_ENCODING);
        return "RD".equals(word) || "-|".equals(word);
    }

    private boolean isLenIVKeyWord(byte[] token) throws IOException {
        String word = new String(token, TOKEN_ENCODING);
        return "/lenIV".equals(word);
    }

    private boolean isCharStringKeyWord(byte[] token) throws IOException {
        String word = new String(token, TOKEN_ENCODING);
        return "/CharStrings".equals(word);
    }

    private int readNumberOfCharStrings(PeekInputStream stream) throws IOException {
        byte[] token = this.readToken(stream);
        String word = new String(token, TOKEN_ENCODING);
        try {
            return Integer.parseInt(word);
        }
        catch (NumberFormatException e) {
            throw new IOException("Number of CharStrings elements is expected.");
        }
    }

    private void throwExceptionIfUnexpectedToken(String expectedValue, byte[] token) throws IOException {
        String valueToCheck = new String(token, TOKEN_ENCODING);
        if (!expectedValue.equals(valueToCheck)) {
            throw new IOException(expectedValue + " was expected but we received " + valueToCheck);
        }
    }

    private void readEndSetEncodingValues(PeekInputStream stream) throws IOException {
        byte[] token = this.readToken(stream);
        boolean lastTokenWasReadOnly = false;
        while (!lastTokenWasReadOnly || !this.isDefKeyWord(token)) {
            if (this.isDupKeyWord(token)) {
                byte[] cidToken = this.readToken(stream);
                byte[] labelToken = this.readToken(stream);
                String cid = new String(cidToken, TOKEN_ENCODING);
                String label = new String(labelToken, TOKEN_ENCODING);
                try {
                    this.type1Font.addCidWithLabel(Integer.parseInt(cid), label);
                }
                catch (NumberFormatException e) {
                    throw new IOException("Invalid encoding : Expected CID value before \"" + label + "\" label");
                }
            } else {
                lastTokenWasReadOnly = this.isReadOnlyKeyWord(token);
            }
            token = this.readToken(stream);
        }
    }

    private byte[] readEexec(PeekInputStream stream) throws IOException {
        int BUFFER_SIZE = 1024;
        byte[] buffer = new byte[BUFFER_SIZE];
        ByteArrayOutputStream eexecPart = new ByteArrayOutputStream();
        int lr = 0;
        int total = 0;
        do {
            if ((lr = stream.read(buffer, 0, BUFFER_SIZE)) == BUFFER_SIZE && total + BUFFER_SIZE < this.eexecSize) {
                eexecPart.write(buffer, 0, BUFFER_SIZE);
                total += BUFFER_SIZE;
                continue;
            }
            if (lr > 0 && total + lr < this.eexecSize) {
                eexecPart.write(buffer, 0, lr);
                total += lr;
                continue;
            }
            if (lr <= 0 || total + lr < this.eexecSize) continue;
            eexecPart.write(buffer, 0, this.eexecSize - total);
            total += this.eexecSize - total;
        } while (this.eexecSize > total && lr > 0);
        IOUtils.closeQuietly((OutputStream)eexecPart);
        return eexecPart.toByteArray();
    }

    private byte[] decodeEexec(byte[] eexec) {
        return Type1FontUtil.eexecDecrypt((byte[])eexec);
    }

    private byte[] readLine(PeekInputStream stream) throws IOException {
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        int currentCharacter = 0;
        do {
            currentCharacter = this.readNextCharacter(stream);
            bytes.add((byte)(currentCharacter & 0xFF));
        } while (10 != currentCharacter && 13 != currentCharacter);
        if (13 == currentCharacter && 10 == stream.peek()) {
            currentCharacter = this.readNextCharacter(stream);
            bytes.add((byte)(currentCharacter & 0xFF));
        }
        byte[] result = new byte[bytes.size()];
        for (int i = 0; i < bytes.size(); ++i) {
            result[i] = (Byte)bytes.get(i);
        }
        return result;
    }

    private byte[] readToken(PeekInputStream stream) throws IOException {
        byte[] token = new byte[]{};
        this.skipBlankSeparators(stream);
        int nextByte = stream.peek();
        if (nextByte < 0) {
            throw new IOException("Unexpected End Of File");
        }
        token = nextByte == 40 ? this.readStringLiteral(stream) : (nextByte == 91 ? this.readArray(stream) : (nextByte == 123 ? this.readProcedure(stream) : this.readNameOrArgument(stream)));
        return token;
    }

    private byte[] readStringLiteral(PeekInputStream stream) throws IOException {
        int opened = 0;
        ArrayList<Integer> buffer = new ArrayList<Integer>();
        int currentByte = 0;
        do {
            if ((currentByte = this.readNextCharacter(stream)) < 0) {
                throw new IOException("Unexpected End Of File");
            }
            if (currentByte == 40) {
                ++opened;
            } else if (currentByte == 41) {
                --opened;
            }
            buffer.add(currentByte);
        } while (opened != 0);
        return this.convertListOfIntToByteArray(buffer);
    }

    private byte[] readArray(PeekInputStream stream) throws IOException {
        int opened = 0;
        ArrayList<Integer> buffer = new ArrayList<Integer>();
        int currentByte = 0;
        do {
            if ((currentByte = this.readNextCharacter(stream)) < 0) {
                throw new IOException("Unexpected End Of File");
            }
            if (currentByte == 91) {
                ++opened;
            } else if (currentByte == 93) {
                --opened;
            }
            buffer.add(currentByte);
        } while (opened != 0);
        return this.convertListOfIntToByteArray(buffer);
    }

    private byte[] readProcedure(PeekInputStream stream) throws IOException {
        int opened = 0;
        ArrayList<Integer> buffer = new ArrayList<Integer>();
        int currentByte = 0;
        do {
            if ((currentByte = this.readNextCharacter(stream)) < 0) {
                throw new IOException("Unexpected End Of File");
            }
            if (currentByte == 123) {
                ++opened;
            } else if (currentByte == 125) {
                --opened;
            }
            buffer.add(currentByte);
        } while (opened != 0);
        return this.convertListOfIntToByteArray(buffer);
    }

    private byte[] readNameOrArgument(PeekInputStream stream) throws IOException {
        ArrayList<Integer> buffer = new ArrayList<Integer>();
        int nextByte = 0;
        do {
            int currentByte;
            if ((currentByte = this.readNextCharacter(stream)) < 0) {
                throw new IOException("Unexpected End Of File");
            }
            buffer.add(currentByte);
        } while (this.isNotBlankSperator(nextByte = stream.peek()) && this.isNotBeginOfName(nextByte) && this.isNotSeparator(nextByte));
        return this.convertListOfIntToByteArray(buffer);
    }

    private boolean isNotBeginOfName(int character) {
        return 47 != character;
    }

    private boolean isNotSeparator(int character) {
        return 123 != character && 125 != character && 91 != character && 93 != character;
    }

    private byte[] convertListOfIntToByteArray(List<Integer> input) {
        byte[] res = new byte[input.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = input.get(i).byteValue();
        }
        return res;
    }

    private int readNextCharacter(PeekInputStream stream) throws IOException {
        int currentByte = stream.read();
        ++this.numberOfReadBytes;
        return currentByte;
    }

    private void skipBlankSeparators(PeekInputStream stream) throws IOException {
        int nextByte = stream.peek();
        while (this.isBlankSperator(nextByte)) {
            this.readNextCharacter(stream);
            nextByte = stream.peek();
        }
    }

    private void skipSingleBlankSeparator(PeekInputStream stream) throws IOException {
        int nextByte = stream.peek();
        if (this.isBlankSperator(nextByte)) {
            this.readNextCharacter(stream);
        }
    }

    private boolean isBlankSperator(int character) {
        return character == 32 || character == 10 || character == 13;
    }

    private boolean isNotBlankSperator(int character) {
        return !this.isBlankSperator(character);
    }

    private boolean isEExecKeyWord(byte[] token) throws IOException {
        String word = new String(token, TOKEN_ENCODING);
        return "eexec".equals(word);
    }

    private boolean isDefKeyWord(byte[] token) throws IOException {
        String word = new String(token, TOKEN_ENCODING);
        return "def".equals(word);
    }

    private boolean isReadOnlyKeyWord(byte[] token) throws IOException {
        String word = new String(token, TOKEN_ENCODING);
        return "readonly".equals(word);
    }

    private boolean isEncodingKeyWord(byte[] token) throws IOException {
        String word = new String(token, TOKEN_ENCODING);
        return "/Encoding".equals(word);
    }

    private boolean isDupKeyWord(byte[] token) throws IOException {
        String word = new String(token, TOKEN_ENCODING);
        return "dup".equals(word);
    }

    private boolean isStartOfEExecReached() {
        return this.numberOfReadBytes == this.clearTextSize;
    }

    private boolean isEndOfStream(PeekInputStream stream) {
        try {
            this.skipBlankSeparators(stream);
            return false;
        }
        catch (IOException e) {
            return true;
        }
    }
}

