/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSUpdateInfo;
import org.apache.pdfbox.cos.COSUpdateState;
import org.apache.pdfbox.pdmodel.common.COSObjectable;

public class COSIncrement
implements Iterable<COSBase> {
    private final Set<COSBase> objects = new LinkedHashSet<COSBase>();
    private final Set<COSBase> excluded = new HashSet<COSBase>();
    private final Set<COSObject> processedObjects = new HashSet<COSObject>();
    private final COSUpdateInfo incrementOrigin;
    private boolean initialized = false;

    public COSIncrement(COSUpdateInfo incrementOrigin) {
        this.incrementOrigin = incrementOrigin;
    }

    private boolean collect(COSBase base) {
        if (this.contains(base)) {
            return false;
        }
        if (base instanceof COSDictionary) {
            return this.collect((COSDictionary)base);
        }
        if (base instanceof COSObject) {
            return this.collect((COSObject)base);
        }
        if (base instanceof COSArray) {
            return this.collect((COSArray)base);
        }
        return false;
    }

    private boolean collect(COSDictionary dictionary) {
        COSUpdateState updateState = dictionary.getUpdateState();
        if (!this.isExcluded(dictionary) && !this.contains(dictionary) && updateState.isUpdated()) {
            this.add(dictionary);
        }
        boolean childDemandsParentUpdate = false;
        for (COSBase entry : dictionary.getValues()) {
            if (!(entry instanceof COSUpdateInfo) || this.contains(entry)) continue;
            COSUpdateInfo updatableEntry = (COSUpdateInfo)((Object)entry);
            COSUpdateState entryUpdateState = updatableEntry.getUpdateState();
            this.updateDifferentOrigin(entryUpdateState);
            if (updatableEntry.isNeedToBeUpdated() && (!(entry instanceof COSObject) && entry.isDirect() || entry instanceof COSArray)) {
                this.exclude(entry);
                childDemandsParentUpdate = true;
            }
            childDemandsParentUpdate = this.collect(entry) || childDemandsParentUpdate;
        }
        if (this.isExcluded(dictionary)) {
            return childDemandsParentUpdate;
        }
        if (childDemandsParentUpdate && !this.contains(dictionary)) {
            this.add(dictionary);
        }
        return false;
    }

    private boolean collect(COSArray array) {
        COSUpdateState updateState = array.getUpdateState();
        boolean childDemandsParentUpdate = updateState.isUpdated();
        for (COSBase entry : array) {
            if (!(entry instanceof COSUpdateInfo) || this.contains(entry)) continue;
            COSUpdateState entryUpdateState = ((COSUpdateInfo)((Object)entry)).getUpdateState();
            this.updateDifferentOrigin(entryUpdateState);
            childDemandsParentUpdate = this.collect(entry) || childDemandsParentUpdate;
        }
        return childDemandsParentUpdate;
    }

    private boolean collect(COSObject object) {
        COSBase base;
        if (this.contains(object)) {
            return false;
        }
        this.addProcessedObject(object);
        COSUpdateState updateState = object.getUpdateState();
        this.updateDifferentOrigin(updateState);
        COSObjectable actual = null;
        if ((updateState.isUpdated() || object.isDereferenced()) && (base = object.getObject()) instanceof COSUpdateInfo) {
            actual = (COSUpdateInfo)((Object)base);
        }
        if (actual == null || this.contains(actual.getCOSObject())) {
            return false;
        }
        boolean childDemandsParentUpdate = false;
        COSUpdateState actualUpdateState = actual.getUpdateState();
        if (actualUpdateState.isUpdated()) {
            childDemandsParentUpdate = true;
        }
        this.exclude(actual.getCOSObject());
        boolean bl = childDemandsParentUpdate = this.collect(actual.getCOSObject()) || childDemandsParentUpdate;
        if (updateState.isUpdated() || childDemandsParentUpdate) {
            this.add(actual.getCOSObject());
        }
        return false;
    }

    public boolean contains(COSBase base) {
        return this.objects.contains(base) || base instanceof COSObject && this.processedObjects.contains((COSObject)base);
    }

    private void updateDifferentOrigin(COSUpdateState updateState) {
        if (this.incrementOrigin != null && updateState != null && this.incrementOrigin.getUpdateState().getOriginDocumentState() != updateState.getOriginDocumentState()) {
            updateState.update();
        }
    }

    private void add(COSBase object) {
        if (object != null) {
            this.objects.add(object);
        }
    }

    private void addProcessedObject(COSObject base) {
        if (base != null) {
            this.processedObjects.add(base);
        }
    }

    public COSIncrement exclude(COSBase ... base) {
        if (base != null) {
            this.excluded.addAll(Arrays.asList(base));
        }
        return this;
    }

    private boolean isExcluded(COSBase base) {
        return this.excluded.contains(base);
    }

    public Set<COSBase> getObjects() {
        if (!this.initialized && this.incrementOrigin != null) {
            this.collect(this.incrementOrigin.getCOSObject());
            this.initialized = true;
        }
        return this.objects;
    }

    @Override
    public Iterator<COSBase> iterator() {
        return this.getObjects().iterator();
    }
}

