/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocumentState;
import org.apache.pdfbox.cos.COSIncrement;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSUpdateInfo;

public class COSUpdateState {
    private final COSUpdateInfo updateInfo;
    private COSDocumentState originDocumentState = null;
    private boolean updated = false;

    public COSUpdateState(COSUpdateInfo updateInfo) {
        this.updateInfo = updateInfo;
    }

    public void setOriginDocumentState(COSDocumentState originDocumentState) {
        this.setOriginDocumentState(originDocumentState, false);
    }

    private void setOriginDocumentState(COSDocumentState originDocumentState, boolean dereferencing) {
        COSBase reference;
        COSObject object;
        if (this.originDocumentState != null || originDocumentState == null) {
            return;
        }
        this.originDocumentState = originDocumentState;
        if (!dereferencing) {
            this.update();
        }
        if (this.updateInfo instanceof COSDictionary) {
            COSDictionary dictionary = (COSDictionary)this.updateInfo;
            for (COSBase entry : dictionary.getValues()) {
                if (!(entry instanceof COSUpdateInfo)) continue;
                ((COSUpdateInfo)((Object)entry)).getUpdateState().setOriginDocumentState(originDocumentState, dereferencing);
            }
        } else if (this.updateInfo instanceof COSArray) {
            COSArray array = (COSArray)this.updateInfo;
            for (COSBase entry : array) {
                if (!(entry instanceof COSUpdateInfo)) continue;
                ((COSUpdateInfo)((Object)entry)).getUpdateState().setOriginDocumentState(originDocumentState, dereferencing);
            }
        } else if (this.updateInfo instanceof COSObject && (object = (COSObject)this.updateInfo).isDereferenced() && (reference = object.getObject()) instanceof COSUpdateInfo) {
            ((COSUpdateInfo)((Object)reference)).getUpdateState().setOriginDocumentState(originDocumentState, dereferencing);
        }
    }

    public COSDocumentState getOriginDocumentState() {
        return this.originDocumentState;
    }

    boolean isAcceptingUpdates() {
        return this.originDocumentState != null && this.originDocumentState.isAcceptingUpdates();
    }

    public boolean isUpdated() {
        return this.updated;
    }

    void update() {
        this.update(true);
    }

    void update(boolean updated) {
        if (this.isAcceptingUpdates()) {
            this.updated = updated;
        }
    }

    void update(COSBase child) {
        this.update();
        if (child instanceof COSUpdateInfo) {
            ((COSUpdateInfo)((Object)child)).getUpdateState().setOriginDocumentState(this.originDocumentState);
        }
    }

    void update(COSArray children) {
        this.update((Iterable<COSBase>)children);
    }

    void update(Iterable<COSBase> children) {
        this.update();
        if (children == null) {
            return;
        }
        for (COSBase child : children) {
            if (!(child instanceof COSUpdateInfo)) continue;
            ((COSUpdateInfo)((Object)child)).getUpdateState().setOriginDocumentState(this.originDocumentState);
        }
    }

    void dereferenceChild(COSBase child) {
        if (child instanceof COSUpdateInfo) {
            ((COSUpdateInfo)((Object)child)).getUpdateState().setOriginDocumentState(this.originDocumentState, true);
        }
    }

    COSIncrement toIncrement() {
        return new COSIncrement(this.updateInfo);
    }
}

