/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.XMPSchema;

public class UniquePropertiesValidation {
    public List<ValidationResult.ValidationError> validatePropertiesUniqueness(PDDocument document, XMPMetadata metadata) throws ValidationException {
        if (document == null) {
            throw new ValidationException("Document provided is null");
        }
        ArrayList<ValidationResult.ValidationError> ve = new ArrayList<ValidationResult.ValidationError>();
        UniquePropertiesValidation.analyzePropertyUniqueness(metadata.getDublinCoreSchema(), "creator", ve);
        UniquePropertiesValidation.analyzePropertyUniqueness(metadata.getDublinCoreSchema(), "title", ve);
        UniquePropertiesValidation.analyzePropertyUniqueness(metadata.getDublinCoreSchema(), "description", ve);
        UniquePropertiesValidation.analyzePropertyUniqueness(metadata.getAdobePDFSchema(), "Producer", ve);
        UniquePropertiesValidation.analyzePropertyUniqueness(metadata.getAdobePDFSchema(), "Keywords", ve);
        UniquePropertiesValidation.analyzePropertyUniqueness(metadata.getXMPBasicSchema(), "CreatorTool", ve);
        UniquePropertiesValidation.analyzePropertyUniqueness(metadata.getXMPBasicSchema(), "CreateDate", ve);
        UniquePropertiesValidation.analyzePropertyUniqueness(metadata.getXMPBasicSchema(), "ModifyDate", ve);
        return ve;
    }

    private static void analyzePropertyUniqueness(XMPSchema schema, String propertyName, List<ValidationResult.ValidationError> ve) {
        if (schema == null) {
            return;
        }
        if (schema.getAllProperties().stream().filter(field -> propertyName.equals(field.getPropertyName())).count() > 1L) {
            ve.add(new ValidationResult.ValidationError("7.1.2", "property '" + schema.getPrefix() + ":" + propertyName + "' occurs multiple times"));
        }
    }
}

