/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetApplicationTagNull is the corresponding interface of BACnetApplicationTagNull
type BACnetApplicationTagNull interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetApplicationTag
	// IsBACnetApplicationTagNull is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetApplicationTagNull()
	// CreateBuilder creates a BACnetApplicationTagNullBuilder
	CreateBACnetApplicationTagNullBuilder() BACnetApplicationTagNullBuilder
}

// _BACnetApplicationTagNull is the data-structure of this message
type _BACnetApplicationTagNull struct {
	BACnetApplicationTagContract
}

var _ BACnetApplicationTagNull = (*_BACnetApplicationTagNull)(nil)
var _ BACnetApplicationTagRequirements = (*_BACnetApplicationTagNull)(nil)

// NewBACnetApplicationTagNull factory function for _BACnetApplicationTagNull
func NewBACnetApplicationTagNull(header BACnetTagHeader) *_BACnetApplicationTagNull {
	_result := &_BACnetApplicationTagNull{
		BACnetApplicationTagContract: NewBACnetApplicationTag(header),
	}
	_result.BACnetApplicationTagContract.(*_BACnetApplicationTag)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetApplicationTagNullBuilder is a builder for BACnetApplicationTagNull
type BACnetApplicationTagNullBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() BACnetApplicationTagNullBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetApplicationTagBuilder
	// Build builds the BACnetApplicationTagNull or returns an error if something is wrong
	Build() (BACnetApplicationTagNull, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetApplicationTagNull
}

// NewBACnetApplicationTagNullBuilder() creates a BACnetApplicationTagNullBuilder
func NewBACnetApplicationTagNullBuilder() BACnetApplicationTagNullBuilder {
	return &_BACnetApplicationTagNullBuilder{_BACnetApplicationTagNull: new(_BACnetApplicationTagNull)}
}

type _BACnetApplicationTagNullBuilder struct {
	*_BACnetApplicationTagNull

	parentBuilder *_BACnetApplicationTagBuilder

	collectedErr []error
}

var _ (BACnetApplicationTagNullBuilder) = (*_BACnetApplicationTagNullBuilder)(nil)

func (b *_BACnetApplicationTagNullBuilder) setParent(contract BACnetApplicationTagContract) {
	b.BACnetApplicationTagContract = contract
	contract.(*_BACnetApplicationTag)._SubType = b._BACnetApplicationTagNull
}

func (b *_BACnetApplicationTagNullBuilder) WithMandatoryFields() BACnetApplicationTagNullBuilder {
	return b
}

func (b *_BACnetApplicationTagNullBuilder) Build() (BACnetApplicationTagNull, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetApplicationTagNull.deepCopy(), nil
}

func (b *_BACnetApplicationTagNullBuilder) MustBuild() BACnetApplicationTagNull {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetApplicationTagNullBuilder) Done() BACnetApplicationTagBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetApplicationTagBuilder().(*_BACnetApplicationTagBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetApplicationTagNullBuilder) buildForBACnetApplicationTag() (BACnetApplicationTag, error) {
	return b.Build()
}

func (b *_BACnetApplicationTagNullBuilder) DeepCopy() any {
	_copy := b.CreateBACnetApplicationTagNullBuilder().(*_BACnetApplicationTagNullBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetApplicationTagNullBuilder creates a BACnetApplicationTagNullBuilder
func (b *_BACnetApplicationTagNull) CreateBACnetApplicationTagNullBuilder() BACnetApplicationTagNullBuilder {
	if b == nil {
		return NewBACnetApplicationTagNullBuilder()
	}
	return &_BACnetApplicationTagNullBuilder{_BACnetApplicationTagNull: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetApplicationTagNull) GetParent() BACnetApplicationTagContract {
	return m.BACnetApplicationTagContract
}

// Deprecated: use the interface for direct cast
func CastBACnetApplicationTagNull(structType any) BACnetApplicationTagNull {
	if casted, ok := structType.(BACnetApplicationTagNull); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetApplicationTagNull); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetApplicationTagNull) GetTypeName() string {
	return "BACnetApplicationTagNull"
}

func (m *_BACnetApplicationTagNull) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetApplicationTagContract.(*_BACnetApplicationTag).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_BACnetApplicationTagNull) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetApplicationTagNull) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetApplicationTag) (__bACnetApplicationTagNull BACnetApplicationTagNull, err error) {
	m.BACnetApplicationTagContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetApplicationTagNull"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetApplicationTagNull")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("BACnetApplicationTagNull"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetApplicationTagNull")
	}

	return m, nil
}

func (m *_BACnetApplicationTagNull) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetApplicationTagNull) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetApplicationTagNull"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetApplicationTagNull")
		}

		if popErr := writeBuffer.PopContext("BACnetApplicationTagNull"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetApplicationTagNull")
		}
		return nil
	}
	return m.BACnetApplicationTagContract.(*_BACnetApplicationTag).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetApplicationTagNull) IsBACnetApplicationTagNull() {}

func (m *_BACnetApplicationTagNull) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetApplicationTagNull) deepCopy() *_BACnetApplicationTagNull {
	if m == nil {
		return nil
	}
	_BACnetApplicationTagNullCopy := &_BACnetApplicationTagNull{
		m.BACnetApplicationTagContract.(*_BACnetApplicationTag).deepCopy(),
	}
	_BACnetApplicationTagNullCopy.BACnetApplicationTagContract.(*_BACnetApplicationTag)._SubType = m
	return _BACnetApplicationTagNullCopy
}

func (m *_BACnetApplicationTagNull) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
