/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataAPDUTimeout is the corresponding interface of BACnetConstructedDataAPDUTimeout
type BACnetConstructedDataAPDUTimeout interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetApduTimeout returns ApduTimeout (property field)
	GetApduTimeout() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataAPDUTimeout is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataAPDUTimeout()
	// CreateBuilder creates a BACnetConstructedDataAPDUTimeoutBuilder
	CreateBACnetConstructedDataAPDUTimeoutBuilder() BACnetConstructedDataAPDUTimeoutBuilder
}

// _BACnetConstructedDataAPDUTimeout is the data-structure of this message
type _BACnetConstructedDataAPDUTimeout struct {
	BACnetConstructedDataContract
	ApduTimeout BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataAPDUTimeout = (*_BACnetConstructedDataAPDUTimeout)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataAPDUTimeout)(nil)

// NewBACnetConstructedDataAPDUTimeout factory function for _BACnetConstructedDataAPDUTimeout
func NewBACnetConstructedDataAPDUTimeout(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, apduTimeout BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataAPDUTimeout {
	if apduTimeout == nil {
		panic("apduTimeout of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataAPDUTimeout must not be nil")
	}
	_result := &_BACnetConstructedDataAPDUTimeout{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		ApduTimeout:                   apduTimeout,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataAPDUTimeoutBuilder is a builder for BACnetConstructedDataAPDUTimeout
type BACnetConstructedDataAPDUTimeoutBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(apduTimeout BACnetApplicationTagUnsignedInteger) BACnetConstructedDataAPDUTimeoutBuilder
	// WithApduTimeout adds ApduTimeout (property field)
	WithApduTimeout(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataAPDUTimeoutBuilder
	// WithApduTimeoutBuilder adds ApduTimeout (property field) which is build by the builder
	WithApduTimeoutBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataAPDUTimeoutBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataAPDUTimeout or returns an error if something is wrong
	Build() (BACnetConstructedDataAPDUTimeout, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataAPDUTimeout
}

// NewBACnetConstructedDataAPDUTimeoutBuilder() creates a BACnetConstructedDataAPDUTimeoutBuilder
func NewBACnetConstructedDataAPDUTimeoutBuilder() BACnetConstructedDataAPDUTimeoutBuilder {
	return &_BACnetConstructedDataAPDUTimeoutBuilder{_BACnetConstructedDataAPDUTimeout: new(_BACnetConstructedDataAPDUTimeout)}
}

type _BACnetConstructedDataAPDUTimeoutBuilder struct {
	*_BACnetConstructedDataAPDUTimeout

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataAPDUTimeoutBuilder) = (*_BACnetConstructedDataAPDUTimeoutBuilder)(nil)

func (b *_BACnetConstructedDataAPDUTimeoutBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataAPDUTimeout
}

func (b *_BACnetConstructedDataAPDUTimeoutBuilder) WithMandatoryFields(apduTimeout BACnetApplicationTagUnsignedInteger) BACnetConstructedDataAPDUTimeoutBuilder {
	return b.WithApduTimeout(apduTimeout)
}

func (b *_BACnetConstructedDataAPDUTimeoutBuilder) WithApduTimeout(apduTimeout BACnetApplicationTagUnsignedInteger) BACnetConstructedDataAPDUTimeoutBuilder {
	b.ApduTimeout = apduTimeout
	return b
}

func (b *_BACnetConstructedDataAPDUTimeoutBuilder) WithApduTimeoutBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataAPDUTimeoutBuilder {
	builder := builderSupplier(b.ApduTimeout.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.ApduTimeout, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataAPDUTimeoutBuilder) Build() (BACnetConstructedDataAPDUTimeout, error) {
	if b.ApduTimeout == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'apduTimeout' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataAPDUTimeout.deepCopy(), nil
}

func (b *_BACnetConstructedDataAPDUTimeoutBuilder) MustBuild() BACnetConstructedDataAPDUTimeout {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataAPDUTimeoutBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataAPDUTimeoutBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataAPDUTimeoutBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataAPDUTimeoutBuilder().(*_BACnetConstructedDataAPDUTimeoutBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataAPDUTimeoutBuilder creates a BACnetConstructedDataAPDUTimeoutBuilder
func (b *_BACnetConstructedDataAPDUTimeout) CreateBACnetConstructedDataAPDUTimeoutBuilder() BACnetConstructedDataAPDUTimeoutBuilder {
	if b == nil {
		return NewBACnetConstructedDataAPDUTimeoutBuilder()
	}
	return &_BACnetConstructedDataAPDUTimeoutBuilder{_BACnetConstructedDataAPDUTimeout: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataAPDUTimeout) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataAPDUTimeout) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_APDU_TIMEOUT
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataAPDUTimeout) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataAPDUTimeout) GetApduTimeout() BACnetApplicationTagUnsignedInteger {
	return m.ApduTimeout
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataAPDUTimeout) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetApduTimeout())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataAPDUTimeout(structType any) BACnetConstructedDataAPDUTimeout {
	if casted, ok := structType.(BACnetConstructedDataAPDUTimeout); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataAPDUTimeout); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataAPDUTimeout) GetTypeName() string {
	return "BACnetConstructedDataAPDUTimeout"
}

func (m *_BACnetConstructedDataAPDUTimeout) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (apduTimeout)
	lengthInBits += m.ApduTimeout.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataAPDUTimeout) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataAPDUTimeout) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataAPDUTimeout BACnetConstructedDataAPDUTimeout, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataAPDUTimeout"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataAPDUTimeout")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	apduTimeout, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "apduTimeout", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'apduTimeout' field"))
	}
	m.ApduTimeout = apduTimeout

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), apduTimeout)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataAPDUTimeout"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataAPDUTimeout")
	}

	return m, nil
}

func (m *_BACnetConstructedDataAPDUTimeout) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataAPDUTimeout) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataAPDUTimeout"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataAPDUTimeout")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "apduTimeout", m.GetApduTimeout(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'apduTimeout' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataAPDUTimeout"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataAPDUTimeout")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataAPDUTimeout) IsBACnetConstructedDataAPDUTimeout() {}

func (m *_BACnetConstructedDataAPDUTimeout) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataAPDUTimeout) deepCopy() *_BACnetConstructedDataAPDUTimeout {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataAPDUTimeoutCopy := &_BACnetConstructedDataAPDUTimeout{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.ApduTimeout),
	}
	_BACnetConstructedDataAPDUTimeoutCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataAPDUTimeoutCopy
}

func (m *_BACnetConstructedDataAPDUTimeout) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
