/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataElapsedActiveTime is the corresponding interface of BACnetConstructedDataElapsedActiveTime
type BACnetConstructedDataElapsedActiveTime interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetElapsedActiveTime returns ElapsedActiveTime (property field)
	GetElapsedActiveTime() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataElapsedActiveTime is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataElapsedActiveTime()
	// CreateBuilder creates a BACnetConstructedDataElapsedActiveTimeBuilder
	CreateBACnetConstructedDataElapsedActiveTimeBuilder() BACnetConstructedDataElapsedActiveTimeBuilder
}

// _BACnetConstructedDataElapsedActiveTime is the data-structure of this message
type _BACnetConstructedDataElapsedActiveTime struct {
	BACnetConstructedDataContract
	ElapsedActiveTime BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataElapsedActiveTime = (*_BACnetConstructedDataElapsedActiveTime)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataElapsedActiveTime)(nil)

// NewBACnetConstructedDataElapsedActiveTime factory function for _BACnetConstructedDataElapsedActiveTime
func NewBACnetConstructedDataElapsedActiveTime(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, elapsedActiveTime BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataElapsedActiveTime {
	if elapsedActiveTime == nil {
		panic("elapsedActiveTime of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataElapsedActiveTime must not be nil")
	}
	_result := &_BACnetConstructedDataElapsedActiveTime{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		ElapsedActiveTime:             elapsedActiveTime,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataElapsedActiveTimeBuilder is a builder for BACnetConstructedDataElapsedActiveTime
type BACnetConstructedDataElapsedActiveTimeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(elapsedActiveTime BACnetApplicationTagUnsignedInteger) BACnetConstructedDataElapsedActiveTimeBuilder
	// WithElapsedActiveTime adds ElapsedActiveTime (property field)
	WithElapsedActiveTime(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataElapsedActiveTimeBuilder
	// WithElapsedActiveTimeBuilder adds ElapsedActiveTime (property field) which is build by the builder
	WithElapsedActiveTimeBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataElapsedActiveTimeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataElapsedActiveTime or returns an error if something is wrong
	Build() (BACnetConstructedDataElapsedActiveTime, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataElapsedActiveTime
}

// NewBACnetConstructedDataElapsedActiveTimeBuilder() creates a BACnetConstructedDataElapsedActiveTimeBuilder
func NewBACnetConstructedDataElapsedActiveTimeBuilder() BACnetConstructedDataElapsedActiveTimeBuilder {
	return &_BACnetConstructedDataElapsedActiveTimeBuilder{_BACnetConstructedDataElapsedActiveTime: new(_BACnetConstructedDataElapsedActiveTime)}
}

type _BACnetConstructedDataElapsedActiveTimeBuilder struct {
	*_BACnetConstructedDataElapsedActiveTime

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataElapsedActiveTimeBuilder) = (*_BACnetConstructedDataElapsedActiveTimeBuilder)(nil)

func (b *_BACnetConstructedDataElapsedActiveTimeBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataElapsedActiveTime
}

func (b *_BACnetConstructedDataElapsedActiveTimeBuilder) WithMandatoryFields(elapsedActiveTime BACnetApplicationTagUnsignedInteger) BACnetConstructedDataElapsedActiveTimeBuilder {
	return b.WithElapsedActiveTime(elapsedActiveTime)
}

func (b *_BACnetConstructedDataElapsedActiveTimeBuilder) WithElapsedActiveTime(elapsedActiveTime BACnetApplicationTagUnsignedInteger) BACnetConstructedDataElapsedActiveTimeBuilder {
	b.ElapsedActiveTime = elapsedActiveTime
	return b
}

func (b *_BACnetConstructedDataElapsedActiveTimeBuilder) WithElapsedActiveTimeBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataElapsedActiveTimeBuilder {
	builder := builderSupplier(b.ElapsedActiveTime.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.ElapsedActiveTime, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataElapsedActiveTimeBuilder) Build() (BACnetConstructedDataElapsedActiveTime, error) {
	if b.ElapsedActiveTime == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'elapsedActiveTime' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataElapsedActiveTime.deepCopy(), nil
}

func (b *_BACnetConstructedDataElapsedActiveTimeBuilder) MustBuild() BACnetConstructedDataElapsedActiveTime {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataElapsedActiveTimeBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataElapsedActiveTimeBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataElapsedActiveTimeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataElapsedActiveTimeBuilder().(*_BACnetConstructedDataElapsedActiveTimeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataElapsedActiveTimeBuilder creates a BACnetConstructedDataElapsedActiveTimeBuilder
func (b *_BACnetConstructedDataElapsedActiveTime) CreateBACnetConstructedDataElapsedActiveTimeBuilder() BACnetConstructedDataElapsedActiveTimeBuilder {
	if b == nil {
		return NewBACnetConstructedDataElapsedActiveTimeBuilder()
	}
	return &_BACnetConstructedDataElapsedActiveTimeBuilder{_BACnetConstructedDataElapsedActiveTime: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataElapsedActiveTime) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataElapsedActiveTime) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ELAPSED_ACTIVE_TIME
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataElapsedActiveTime) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataElapsedActiveTime) GetElapsedActiveTime() BACnetApplicationTagUnsignedInteger {
	return m.ElapsedActiveTime
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataElapsedActiveTime) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetElapsedActiveTime())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataElapsedActiveTime(structType any) BACnetConstructedDataElapsedActiveTime {
	if casted, ok := structType.(BACnetConstructedDataElapsedActiveTime); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataElapsedActiveTime); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataElapsedActiveTime) GetTypeName() string {
	return "BACnetConstructedDataElapsedActiveTime"
}

func (m *_BACnetConstructedDataElapsedActiveTime) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (elapsedActiveTime)
	lengthInBits += m.ElapsedActiveTime.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataElapsedActiveTime) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataElapsedActiveTime) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataElapsedActiveTime BACnetConstructedDataElapsedActiveTime, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataElapsedActiveTime"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataElapsedActiveTime")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	elapsedActiveTime, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "elapsedActiveTime", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'elapsedActiveTime' field"))
	}
	m.ElapsedActiveTime = elapsedActiveTime

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), elapsedActiveTime)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataElapsedActiveTime"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataElapsedActiveTime")
	}

	return m, nil
}

func (m *_BACnetConstructedDataElapsedActiveTime) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataElapsedActiveTime) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataElapsedActiveTime"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataElapsedActiveTime")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "elapsedActiveTime", m.GetElapsedActiveTime(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'elapsedActiveTime' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataElapsedActiveTime"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataElapsedActiveTime")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataElapsedActiveTime) IsBACnetConstructedDataElapsedActiveTime() {}

func (m *_BACnetConstructedDataElapsedActiveTime) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataElapsedActiveTime) deepCopy() *_BACnetConstructedDataElapsedActiveTime {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataElapsedActiveTimeCopy := &_BACnetConstructedDataElapsedActiveTime{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.ElapsedActiveTime),
	}
	_BACnetConstructedDataElapsedActiveTimeCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataElapsedActiveTimeCopy
}

func (m *_BACnetConstructedDataElapsedActiveTime) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
