/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetLandingCallStatus is the corresponding interface of BACnetLandingCallStatus
type BACnetLandingCallStatus interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetFloorNumber returns FloorNumber (property field)
	GetFloorNumber() BACnetContextTagUnsignedInteger
	// GetCommand returns Command (property field)
	GetCommand() BACnetLandingCallStatusCommand
	// GetFloorText returns FloorText (property field)
	GetFloorText() BACnetContextTagCharacterString
	// IsBACnetLandingCallStatus is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetLandingCallStatus()
	// CreateBuilder creates a BACnetLandingCallStatusBuilder
	CreateBACnetLandingCallStatusBuilder() BACnetLandingCallStatusBuilder
}

// _BACnetLandingCallStatus is the data-structure of this message
type _BACnetLandingCallStatus struct {
	FloorNumber BACnetContextTagUnsignedInteger
	Command     BACnetLandingCallStatusCommand
	FloorText   BACnetContextTagCharacterString
}

var _ BACnetLandingCallStatus = (*_BACnetLandingCallStatus)(nil)

// NewBACnetLandingCallStatus factory function for _BACnetLandingCallStatus
func NewBACnetLandingCallStatus(floorNumber BACnetContextTagUnsignedInteger, command BACnetLandingCallStatusCommand, floorText BACnetContextTagCharacterString) *_BACnetLandingCallStatus {
	if floorNumber == nil {
		panic("floorNumber of type BACnetContextTagUnsignedInteger for BACnetLandingCallStatus must not be nil")
	}
	if command == nil {
		panic("command of type BACnetLandingCallStatusCommand for BACnetLandingCallStatus must not be nil")
	}
	return &_BACnetLandingCallStatus{FloorNumber: floorNumber, Command: command, FloorText: floorText}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetLandingCallStatusBuilder is a builder for BACnetLandingCallStatus
type BACnetLandingCallStatusBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(floorNumber BACnetContextTagUnsignedInteger, command BACnetLandingCallStatusCommand) BACnetLandingCallStatusBuilder
	// WithFloorNumber adds FloorNumber (property field)
	WithFloorNumber(BACnetContextTagUnsignedInteger) BACnetLandingCallStatusBuilder
	// WithFloorNumberBuilder adds FloorNumber (property field) which is build by the builder
	WithFloorNumberBuilder(func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetLandingCallStatusBuilder
	// WithCommand adds Command (property field)
	WithCommand(BACnetLandingCallStatusCommand) BACnetLandingCallStatusBuilder
	// WithCommandBuilder adds Command (property field) which is build by the builder
	WithCommandBuilder(func(BACnetLandingCallStatusCommandBuilder) BACnetLandingCallStatusCommandBuilder) BACnetLandingCallStatusBuilder
	// WithFloorText adds FloorText (property field)
	WithOptionalFloorText(BACnetContextTagCharacterString) BACnetLandingCallStatusBuilder
	// WithOptionalFloorTextBuilder adds FloorText (property field) which is build by the builder
	WithOptionalFloorTextBuilder(func(BACnetContextTagCharacterStringBuilder) BACnetContextTagCharacterStringBuilder) BACnetLandingCallStatusBuilder
	// Build builds the BACnetLandingCallStatus or returns an error if something is wrong
	Build() (BACnetLandingCallStatus, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetLandingCallStatus
}

// NewBACnetLandingCallStatusBuilder() creates a BACnetLandingCallStatusBuilder
func NewBACnetLandingCallStatusBuilder() BACnetLandingCallStatusBuilder {
	return &_BACnetLandingCallStatusBuilder{_BACnetLandingCallStatus: new(_BACnetLandingCallStatus)}
}

type _BACnetLandingCallStatusBuilder struct {
	*_BACnetLandingCallStatus

	collectedErr []error
}

var _ (BACnetLandingCallStatusBuilder) = (*_BACnetLandingCallStatusBuilder)(nil)

func (b *_BACnetLandingCallStatusBuilder) WithMandatoryFields(floorNumber BACnetContextTagUnsignedInteger, command BACnetLandingCallStatusCommand) BACnetLandingCallStatusBuilder {
	return b.WithFloorNumber(floorNumber).WithCommand(command)
}

func (b *_BACnetLandingCallStatusBuilder) WithFloorNumber(floorNumber BACnetContextTagUnsignedInteger) BACnetLandingCallStatusBuilder {
	b.FloorNumber = floorNumber
	return b
}

func (b *_BACnetLandingCallStatusBuilder) WithFloorNumberBuilder(builderSupplier func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetLandingCallStatusBuilder {
	builder := builderSupplier(b.FloorNumber.CreateBACnetContextTagUnsignedIntegerBuilder())
	var err error
	b.FloorNumber, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetLandingCallStatusBuilder) WithCommand(command BACnetLandingCallStatusCommand) BACnetLandingCallStatusBuilder {
	b.Command = command
	return b
}

func (b *_BACnetLandingCallStatusBuilder) WithCommandBuilder(builderSupplier func(BACnetLandingCallStatusCommandBuilder) BACnetLandingCallStatusCommandBuilder) BACnetLandingCallStatusBuilder {
	builder := builderSupplier(b.Command.CreateBACnetLandingCallStatusCommandBuilder())
	var err error
	b.Command, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetLandingCallStatusCommandBuilder failed"))
	}
	return b
}

func (b *_BACnetLandingCallStatusBuilder) WithOptionalFloorText(floorText BACnetContextTagCharacterString) BACnetLandingCallStatusBuilder {
	b.FloorText = floorText
	return b
}

func (b *_BACnetLandingCallStatusBuilder) WithOptionalFloorTextBuilder(builderSupplier func(BACnetContextTagCharacterStringBuilder) BACnetContextTagCharacterStringBuilder) BACnetLandingCallStatusBuilder {
	builder := builderSupplier(b.FloorText.CreateBACnetContextTagCharacterStringBuilder())
	var err error
	b.FloorText, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagCharacterStringBuilder failed"))
	}
	return b
}

func (b *_BACnetLandingCallStatusBuilder) Build() (BACnetLandingCallStatus, error) {
	if b.FloorNumber == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'floorNumber' not set"))
	}
	if b.Command == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'command' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetLandingCallStatus.deepCopy(), nil
}

func (b *_BACnetLandingCallStatusBuilder) MustBuild() BACnetLandingCallStatus {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetLandingCallStatusBuilder) DeepCopy() any {
	_copy := b.CreateBACnetLandingCallStatusBuilder().(*_BACnetLandingCallStatusBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetLandingCallStatusBuilder creates a BACnetLandingCallStatusBuilder
func (b *_BACnetLandingCallStatus) CreateBACnetLandingCallStatusBuilder() BACnetLandingCallStatusBuilder {
	if b == nil {
		return NewBACnetLandingCallStatusBuilder()
	}
	return &_BACnetLandingCallStatusBuilder{_BACnetLandingCallStatus: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetLandingCallStatus) GetFloorNumber() BACnetContextTagUnsignedInteger {
	return m.FloorNumber
}

func (m *_BACnetLandingCallStatus) GetCommand() BACnetLandingCallStatusCommand {
	return m.Command
}

func (m *_BACnetLandingCallStatus) GetFloorText() BACnetContextTagCharacterString {
	return m.FloorText
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetLandingCallStatus(structType any) BACnetLandingCallStatus {
	if casted, ok := structType.(BACnetLandingCallStatus); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetLandingCallStatus); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetLandingCallStatus) GetTypeName() string {
	return "BACnetLandingCallStatus"
}

func (m *_BACnetLandingCallStatus) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (floorNumber)
	lengthInBits += m.FloorNumber.GetLengthInBits(ctx)

	// Simple field (command)
	lengthInBits += m.Command.GetLengthInBits(ctx)

	// Optional Field (floorText)
	if m.FloorText != nil {
		lengthInBits += m.FloorText.GetLengthInBits(ctx)
	}

	return lengthInBits
}

func (m *_BACnetLandingCallStatus) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetLandingCallStatusParse(ctx context.Context, theBytes []byte) (BACnetLandingCallStatus, error) {
	return BACnetLandingCallStatusParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetLandingCallStatusParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetLandingCallStatus, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetLandingCallStatus, error) {
		return BACnetLandingCallStatusParseWithBuffer(ctx, readBuffer)
	}
}

func BACnetLandingCallStatusParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetLandingCallStatus, error) {
	v, err := (&_BACnetLandingCallStatus{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetLandingCallStatus) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__bACnetLandingCallStatus BACnetLandingCallStatus, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetLandingCallStatus"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetLandingCallStatus")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	floorNumber, err := ReadSimpleField[BACnetContextTagUnsignedInteger](ctx, "floorNumber", ReadComplex[BACnetContextTagUnsignedInteger](BACnetContextTagParseWithBufferProducer[BACnetContextTagUnsignedInteger]((uint8)(uint8(0)), (BACnetDataType)(BACnetDataType_UNSIGNED_INTEGER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'floorNumber' field"))
	}
	m.FloorNumber = floorNumber

	command, err := ReadSimpleField[BACnetLandingCallStatusCommand](ctx, "command", ReadComplex[BACnetLandingCallStatusCommand](BACnetLandingCallStatusCommandParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'command' field"))
	}
	m.Command = command

	var floorText BACnetContextTagCharacterString
	_floorText, err := ReadOptionalField[BACnetContextTagCharacterString](ctx, "floorText", ReadComplex[BACnetContextTagCharacterString](BACnetContextTagParseWithBufferProducer[BACnetContextTagCharacterString]((uint8)(uint8(3)), (BACnetDataType)(BACnetDataType_CHARACTER_STRING)), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'floorText' field"))
	}
	if _floorText != nil {
		floorText = *_floorText
		m.FloorText = floorText
	}

	if closeErr := readBuffer.CloseContext("BACnetLandingCallStatus"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetLandingCallStatus")
	}

	return m, nil
}

func (m *_BACnetLandingCallStatus) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetLandingCallStatus) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetLandingCallStatus"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetLandingCallStatus")
	}

	if err := WriteSimpleField[BACnetContextTagUnsignedInteger](ctx, "floorNumber", m.GetFloorNumber(), WriteComplex[BACnetContextTagUnsignedInteger](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'floorNumber' field")
	}

	if err := WriteSimpleField[BACnetLandingCallStatusCommand](ctx, "command", m.GetCommand(), WriteComplex[BACnetLandingCallStatusCommand](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'command' field")
	}

	if err := WriteOptionalField[BACnetContextTagCharacterString](ctx, "floorText", GetRef(m.GetFloorText()), WriteComplex[BACnetContextTagCharacterString](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'floorText' field")
	}

	if popErr := writeBuffer.PopContext("BACnetLandingCallStatus"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetLandingCallStatus")
	}
	return nil
}

func (m *_BACnetLandingCallStatus) IsBACnetLandingCallStatus() {}

func (m *_BACnetLandingCallStatus) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetLandingCallStatus) deepCopy() *_BACnetLandingCallStatus {
	if m == nil {
		return nil
	}
	_BACnetLandingCallStatusCopy := &_BACnetLandingCallStatus{
		utils.DeepCopy[BACnetContextTagUnsignedInteger](m.FloorNumber),
		utils.DeepCopy[BACnetLandingCallStatusCommand](m.Command),
		utils.DeepCopy[BACnetContextTagCharacterString](m.FloorText),
	}
	return _BACnetLandingCallStatusCopy
}

func (m *_BACnetLandingCallStatus) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
